package com.sentray.kmmprotocolmodule.network.tcp

import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch

internal object TcpClientManager {
    private const val port = 8088
    private val tcpClientCacheHashMap: MutableMap<String, TcpClient> = mutableMapOf()

    suspend fun createControllerTcpClient(host: String, mac: String): TcpClient.ETcpSocketStatus {
        var result = TcpClient.ETcpSocketStatus.Disconnected
        getControllerTcpClient(mac)?.let {
            it.disconnectManually()
            result = it.startConnect()
            if (result == TcpClient.ETcpSocketStatus.Connected) {
                tcpClientCacheHashMap[mac] = it
            }
        } ?: run {
            val tcpClient = TcpClient(host, port)
            result = tcpClient.startConnect()
            if (result == TcpClient.ETcpSocketStatus.Connected) {
                tcpClientCacheHashMap[mac] = tcpClient
            }
        }
        return result
    }

    fun removeControllerTcpClient(mac: String) {
        tcpClientCacheHashMap[mac]?.disconnectManually()
        tcpClientCacheHashMap.remove(mac)
    }

    fun sendDataToController(mac: String, message: String) {
        CoroutineScope(Dispatchers.Default).launch {
            tcpClientCacheHashMap[mac]?.sendData(message)
        }
    }

    private fun getControllerTcpClient(mac: String): TcpClient? {
        return tcpClientCacheHashMap[mac]
    }
}