package com.sentray.kmmprotocolmodule.sdk.command

import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.enumDefinition.ENetworkType
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.enumDefinition.ProtocolVersion
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolCreator.CommandData
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolCreator.GatewayCmdCreator
import kotlin.jvm.JvmStatic

//网关命令
class GatewayCmd {
    companion object {
        @JvmStatic
        fun getGatewayFirmwareVersionCmd(
            sn: String,
            protocolVersion: ProtocolVersion = ProtocolVersion.V2,
            networkType: ENetworkType = ENetworkType.Cloud
        ): CommandData {
            return GatewayCmdCreator.getGatewayFirmwareVersion(
                sn,
                protocolVersion = protocolVersion,
                networkType = networkType
            )
        }

        //TODO: 待考虑
        @JvmStatic
        fun startGatewayFirmwareUpgrade(): CommandData {
            return CommandData(seq = 0, cmdString = "")
        }
    }
}