package com.sentray.kmmprotocolmodule.sdk.parser.parserResult

import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.ProtocolContent
import kotlinx.serialization.ExperimentalSerializationApi
import kotlinx.serialization.Serializable
import kotlinx.serialization.encodeToString
import kotlinx.serialization.json.Json

@Serializable
class ParserResult {
    var baseInfo: BaseInfo? = null
    var controllableDeviceInfo: ControllableDeviceInfo? = null
    var detectableDeviceInfo: DetectableDeviceInfo? = null
    var timerInfo: TimerInfo? = null

    internal constructor(paraContent: ProtocolContent) {
        paraContent.baseContent?.sn?.let { sn ->
            paraContent.baseContent?.let {
                baseInfo = BaseInfo(it)
            }
            paraContent.outputDevContent?.let {
                controllableDeviceInfo = ControllableDeviceInfo(sn, it)
            }
            paraContent.inputDevContent?.let { inputDevContent ->
                paraContent.baseContent?.let { baseContent ->
                    detectableDeviceInfo = DetectableDeviceInfo(sn, baseContent, inputDevContent)
                }
            }
            paraContent.timerContent?.let {
                timerInfo = TimerInfo(it)
            }
        }
    }

    fun stringify(): String {
        return this.toString()
    }

    @OptIn(ExperimentalSerializationApi::class)
    override fun toString(): String {
        val json = Json {
            prettyPrint = true
            explicitNulls = false
            encodeDefaults = true
            allowStructuredMapKeys = true
        }
        return json.encodeToString(this)
    }
}













