package com.sentray.kmmprotocolmodule.tcpProtocol.cache

import com.sentray.kmmprotocolmodule.sdk.parser.parserResult.ParserResult


internal typealias SeqSynCmdResponseCallback = (sn: String, seq: Int, parseResult: ParserResult) -> Unit

//addUserActionAck 需要通过 seq 来判断是否所有 userAction 均有回复
//设置命令ack 可以通过 sn devType jackIndex cmdAck （seq 貌似也行）即可判断
internal object SeqSyncCmdResponseCallbackCache {
    private val callbackMap = mutableMapOf<String, SeqSynCmdResponseCallback>()

    fun insertCallback(
        sn: String,
        seq: Long,
        callback: SeqSynCmdResponseCallback
    ) {
        val key = createKey(sn, seq)
        callbackMap[key] = callback
    }

    fun invokeCallback(parseResult: ParserResult) {
        val sn = parseResult.baseInfo?.sn ?: return
        val seq = parseResult.baseInfo?.seq ?: return

        val key = createKey(sn, seq)
        callbackMap[key]?.let { callback ->
            callback.invoke(sn, seq.toInt(), parseResult)
            callbackMap.remove(key)
        }
    }

    private fun createKey(sn: String, seq: Long): String {
        return "$sn$seq"
    }
}