package com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.paraContent

import com.sentray.kmmprotocolmodule.tcpProtocol.definition.deviceType.DeviceTypeSet
import com.sentray.kmmprotocolmodule.tcpProtocol.definition.deviceType.DeviceTypeUtil
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.enumDefinition.ProtocolKey
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolParser.parserUtil.value
import com.sentray.kmmprotocolmodule.utilityToolKit.HexToolKit
import kotlinx.serialization.Serializable
import kotlinx.serialization.json.JsonObject

@Serializable
internal class UserActionPara {
    var actionIndex: Int = 0
    var devType: DeviceTypeSet = DeviceTypeSet.Unknown
    var rlyAction: List<Boolean>? = null
    var rlyMask: List<Boolean>? = null
    var paraList: List<ParaStructure>? = null
    var paraMask: List<Boolean>? = null

    //[index,devType,rlyAction,rlyMask，paraMask ,para1,para2,para3…]
    fun initialFromRawList(userActionParaRawList: List<Long>) {
        if (userActionParaRawList.count() >= 5) {
            //actionIndex
            this.actionIndex = userActionParaRawList[0].toInt()

            //devType
            DeviceTypeUtil.findDeviceTypeString(userActionParaRawList[1].toInt())
                ?.let { devTypeString ->
                    DeviceTypeSet.fromRaw(devTypeString)?.let {
                        this.devType = it
                    }
                }

            //rlyAction
            this.rlyAction = HexToolKit.longToBoolList(userActionParaRawList[2].toULong())

            //rlyMask
            this.rlyMask = HexToolKit.longToBoolList(userActionParaRawList[3].toULong())

            //paraMask
            val paraMaskNum = userActionParaRawList[4]
            this.paraMask = HexToolKit.longToBoolList(paraMaskNum.toULong())

            //paraValue
            //若 paraMask 中有任意 bit 为 true，则说明有 paraValue
            val paraListNew = mutableListOf<ParaStructure>()
            if (paraMaskNum > 0L) {
                (5 until userActionParaRawList.count()).forEach { index ->
                    paraListNew.add(ParaStructure(userActionParaRawList[index].toULong()))
                }
            }

            this.paraList = paraListNew.toList()
        }
    }

    //$$${"sn":"SN123456","seq":8, "factoryID":123456,"cmd":"addActionAck","confVer":12345,“actionIndex”：0，"devType":1,"rlyAction":"1","rlyMask":"1"，"para":[10，20,30],"paraMask":“7”} }###
    fun initialFromRawJsonObject(jsonObject: JsonObject) {
        jsonObject.value<Int>(ProtocolKey.ActionIndex.raw)?.let {
            this.actionIndex = it
        }
        jsonObject.value<Int>(ProtocolKey.DevType.raw)?.let { devTypeNum ->
            DeviceTypeUtil.findDeviceTypeString(devTypeNum)?.let { devTypeString ->
                DeviceTypeSet.fromRaw(devTypeString)?.let {
                    this.devType = it
                }
            }
        }
        jsonObject.value<String>(ProtocolKey.RlyAction.raw)?.let { hexString ->
            HexToolKit.hexStringToBoolList(hexString)?.let {
                this.rlyAction = it
            }
        }
        jsonObject.value<String>(ProtocolKey.RlyMask.raw)?.let { hexString ->
            HexToolKit.hexStringToBoolList(hexString)?.let {
                this.rlyMask = it
            }
        }
        jsonObject.value<List<Long>>(ProtocolKey.Para.raw)?.let { paraRawList ->
            val paraListNew: MutableList<ParaStructure> = mutableListOf()
            paraRawList.forEach {
                paraListNew.add(ParaStructure(it.toULong()))
            }
            this.paraList = paraListNew.toList()
        }
        jsonObject.value<String>(ProtocolKey.ParaMask.raw)?.let { hexString ->
            HexToolKit.hexStringToBoolList(hexString)?.let {
                this.paraMask = it
            }
        }
    }
}