package com.sentray.kmmprotocolmodule.tcpProtocol.protocolCreator

import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.enumDefinition.*
import kotlinx.serialization.ExperimentalSerializationApi
import kotlinx.serialization.Serializable
import kotlinx.serialization.encodeToString
import kotlinx.serialization.json.Json
import kotlin.jvm.JvmStatic

@OptIn(ExperimentalSerializationApi::class)
internal class GatewayCmdCreator {
    companion object {
        @Serializable
        data class GetFieldPara(
            val sn: String,
            val seq: Int,
            val factoryID: Int,
            val cmd: String,
            val field: List<String>,
        )

        //获取中控版本号
        @JvmStatic
        fun getGatewayFirmwareVersion(
            sn: String,
            factoryID: FactoryID = FactoryID.WILINK,
            protocolVersion: ProtocolVersion = ProtocolVersion.V2,
            networkType: ENetworkType = ENetworkType.Cloud
        ): CommandData {
            val seq = Util.randomSeq()
            val para = GetFieldPara(
                sn,
                seq,
                factoryID.raw,
                Cmd.Get.raw,
                listOf(ProtocolKey.FwVersion.raw),
            )
            val cmdRaw = Json.encodeToString(para)
            val cmdString = Util.encode(cmdRaw, protocolVersion, networkType)
            return CommandData(seq, cmdString)
        }

        @Serializable
        private data class GatewayUpgradePara(
            val sn: String,
            val seq: Int,
            val factoryID: Int,
            val cmd: String,
            val updateUrl: String,
            val updatePort: Int,
            val fwPath: String,
        )

        //通知中控进行升级
        //TODO: 考虑点名中控、V1 中控、V2 中控
        @JvmStatic
        fun startGatewayFirmwareUpgrade(
            sn: String,
            factoryID: FactoryID = FactoryID.WILINK,
            updateUrl: String,
            updatePort: Int,
            firmwarePath: String,
            protocolVersion: ProtocolVersion = ProtocolVersion.V2,
            networkType: ENetworkType = ENetworkType.Cloud
        ): String {
            val para = GatewayUpgradePara(
                sn,
                Util.randomSeq(),
                factoryID.raw,
                Cmd.FwUpgrade.raw,
                updateUrl,
                updatePort,
                firmwarePath,
            )
            val cmdRaw = Json.encodeToString(para)
            return Util.encode(cmdRaw, protocolVersion, networkType)
        }
    }
}