package com.sentray.kmmprotocolmodule.tcpProtocol.protocolParser.parserUtil

import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.ProtocolContent
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.enumDefinition.*
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.paraContent.FirmwareVersion
import kotlinx.serialization.json.JsonObject

internal fun ProtocolContent.parseBaseInfo(
    jsonObject: JsonObject,
    protocolVersion: ProtocolVersion
) {
    val baseContentNew = ProtocolContent.BaseContent().also {
        it.sn = jsonObject.value(ProtocolKey.Sn.raw)
        it.seq = jsonObject.value(ProtocolKey.Seq.raw)
        jsonObject.value<String>(ProtocolKey.Cmd.raw)?.let { cmdStr ->
            Cmd.fromRaw(cmdStr)?.let { cmd ->
                it.cmd = cmd
            }
        }
        it.serviceDomain = jsonObject.value(ProtocolKey.ServiceDomain.raw)
//        jsonObject.value<Int>(ProtocolKey.ProtocolVersion.raw)?.let { protocolVersionNum ->
//            ProtocolVersion.fromRaw(protocolVersionNum)?.let { protocolVersion ->
//                it.protocolVersion = protocolVersion
//            }
//        } ?: run {
//            //点名中控版本，protocolVersion 为 null，此处人为赋值 V1
//            it.protocolVersion = ProtocolVersion.V1
//        }
        it.protocolVersion = protocolVersion

        jsonObject.value<Int>(ProtocolKey.FactoryID.raw)?.let { factoryIDNum ->
            FactoryID.fromRaw(factoryIDNum)?.let { factoryID ->
                it.factoryID = factoryID
            }
        }
        jsonObject.value<Int>(ProtocolKey.ProductionID.raw)?.let { productionIDNum ->
            ProductionID.fromRaw(productionIDNum)?.let { productionID ->
                it.productionID = productionID
            }
        }
        it.hardwareID = jsonObject.value(ProtocolKey.HardwareID.raw)
        it.fwPath = jsonObject.value(ProtocolKey.FwPath.raw)
        jsonObject.value<String>(ProtocolKey.FwVersion.raw)?.let { fwVersionString ->
            it.fwVersion =
                FirmwareVersion().also { fwVersion -> fwVersion.initialFromString(fwVersionString) }
        }
        it.confVer = jsonObject.value(ProtocolKey.ConfVer.raw)
        it.failure = jsonObject.value(ProtocolKey.Failure.raw)
    }
    if (baseContentNew.isNotEmpty()) {
        this.baseContent = baseContentNew
    }
//    freeze(this.baseContent)
}
