package com.sentray.kmmprotocolmodule.tcpProtocol.protocolParser.parserUtil

import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.ProtocolContent
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.enumDefinition.Cmd
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.enumDefinition.ProtocolKey
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.paraContent.FirmwareVersion
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.paraContent.TriggerPara
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.paraContent.UserActionPara
import com.sentray.kmmprotocolmodule.utilityToolKit.HexToolKit
import kotlinx.serialization.json.JsonObject

internal fun ProtocolContent.parseInputDeviceContent(jsonObject: JsonObject) {
    val inputDevContentNew = ProtocolContent.InputDevContent().also { inputDevContent ->
        //inputDeviceInstalled
        jsonObject.value<String>(ProtocolKey.InputDeviceInstalled.raw)?.let { hexString ->
            HexToolKit.hexStringToBoolList(hexString)?.let {
                inputDevContent.inputDeviceInstalled = it
            }
        }

        //ver
        jsonObject.value<String>(ProtocolKey.Ver.raw)?.let { verString ->
            inputDevContent.ver = FirmwareVersion().also { it.initialFromString(verString) }
        }

        //triggerStatus
        jsonObject.value<String>(ProtocolKey.TriggerStatus.raw)?.let { hexString ->
            HexToolKit.hexStringToBoolList(hexString)?.let {
                inputDevContent.triggerStatus = it
            }
        }

        //noDisableTrigger
        jsonObject.value<String>(ProtocolKey.NoDisableTrigger.raw)?.let { hexString ->
            HexToolKit.hexStringToBoolList(hexString)?.let {
                inputDevContent.noDisableTrigger = it
            }
        }

        //trigger
        val triggerParaList: MutableList<TriggerPara> = mutableListOf()
        //1. getTriggerAck & inputDeviceLearnAck
        jsonObject.value<List<List<Long>>>(ProtocolKey.Trigger.raw)
            ?.let { triggerParaRawListList ->
                triggerParaRawListList.forEach { triggerRawList ->
                    triggerParaList.add(TriggerPara().also { it.initialFromRawList(triggerRawList) })
                }
            }
        //2. setTriggerActionAck
        when (this.baseContent?.cmd) {
            Cmd.SetTriggerActionAck -> {
                triggerParaList.add(TriggerPara().also { it.initialFromRawJsonObject(jsonObject) })
            }
            //3. setTriggerDefaultActionAck
            Cmd.SetTriggerDefaultActionAck -> {
                triggerParaList.add(TriggerPara().also { it.initialFromRawJsonObject(jsonObject) })
            }
            //4. setTriggerDelayAck
            Cmd.SetTriggerDelayAck -> {
                triggerParaList.add(TriggerPara().also { it.initialFromRawJsonObject(jsonObject) })
            }
            else -> {
            }
        }
        if (triggerParaList.isNotEmpty()) {
            inputDevContent.triggerParaList = triggerParaList.toList()
        }

        //inputDeviceIndex
        jsonObject.value<Int>(ProtocolKey.InputDeviceIndex.raw)?.let {
            inputDevContent.inputDeviceIndex = it
        }

        //actionInstalled
        jsonObject.value<String>(ProtocolKey.ActionInstalled.raw)?.let { hexString ->
            HexToolKit.hexStringToBoolList(hexString)?.let {
                inputDevContent.actionInstalled = it
            }
        }

        //userActionParaList
        val userActionParaListNew: MutableList<UserActionPara> = mutableListOf()
        when (this.baseContent?.cmd) {
            //1. getActionAck
            Cmd.GetActionAck -> {
                jsonObject.value<List<List<Long>>>(ProtocolKey.UserAction.raw)
                    ?.let { userActionParaRawListList ->
                        userActionParaRawListList.forEach { userActionRawList ->
                            userActionParaListNew.add(UserActionPara().also {
                                it.initialFromRawList(userActionRawList)
                            })
                        }
                    }
            }
            //2. addActionAck
            Cmd.AddActionAck -> {
                userActionParaListNew.add(UserActionPara().also {
                    it.initialFromRawJsonObject(jsonObject)
                })
            }
            else -> {
            }
        }
        if (userActionParaListNew.isNotEmpty()) {
            inputDevContent.userActionParaList = userActionParaListNew.toList()
        }
    }
    if (inputDevContentNew.isNotEmpty()) {
        this.inputDevContent = inputDevContentNew
    }
//    freeze(this.inputDevContent)
}
