/*
 * Decompiled with CFR 0.152.
 */
package com.bitmart.api;

import com.bitmart.api.CloudContext;
import com.bitmart.api.common.CloudException;
import com.bitmart.api.common.CloudLimit;
import com.bitmart.api.common.CloudResponse;
import com.bitmart.api.common.CommonUtils;
import com.bitmart.api.common.JsonUtils;
import com.bitmart.api.key.CloudSignature;
import com.bitmart.api.request.Auth;
import com.bitmart.api.request.CloudRequest;
import com.bitmart.api.request.Method;
import java.io.IOException;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Call {
    private static final Logger log = LoggerFactory.getLogger(Call.class);
    private final CloudContext cloudContext;
    private static final OkHttpClient okHttpClient = Call.defaultOkHttpClient();
    private static final String USER_AGENT = "BitMart-Java-SDK-API/1.0.0";

    private static OkHttpClient defaultOkHttpClient() {
        HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor();
        interceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        return new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).readTimeout(20L, TimeUnit.SECONDS).writeTimeout(20L, TimeUnit.SECONDS).build();
    }

    public Call(CloudContext cloudContext) {
        this.cloudContext = cloudContext;
    }

    public CloudResponse callCloud(CloudRequest cloudRequest) throws CloudException {
        return Method.POST.equals((Object)cloudRequest.getMethod()) ? this.post(cloudRequest) : this.get(cloudRequest);
    }

    private CloudResponse post(CloudRequest cloudRequest) throws CloudException {
        if (cloudRequest == null) {
            throw new CloudException("request can not null");
        }
        Map<String, String> paraMap = CommonUtils.genRequestMap(cloudRequest);
        String json = JsonUtils.toJson(paraMap);
        MediaType parse = MediaType.Companion.parse("application/json; charset=utf-8");
        RequestBody requestBody = RequestBody.Companion.create(json, parse);
        Headers header = this.setHeaders(cloudRequest, json);
        Request request = new Request.Builder().url(this.cloudContext.getCloudUrl() + cloudRequest.getPath()).headers(header).post(requestBody).build();
        okhttp3.Call okCall = okHttpClient.newCall(request);
        return this.getResponse(paraMap, okCall);
    }

    private CloudResponse get(CloudRequest cloudRequest) throws CloudException {
        if (cloudRequest == null) {
            throw new CloudException("request can not null");
        }
        StringJoiner url = new StringJoiner("");
        Map<String, String> paraMap = CommonUtils.genRequestMap(cloudRequest);
        url.add(this.cloudContext.getCloudUrl() + cloudRequest.getPath());
        if (!paraMap.isEmpty()) {
            url.add("?");
        }
        String queryString = this.getQueryString(paraMap);
        Headers header = this.setHeaders(cloudRequest, queryString);
        Request request = new Request.Builder().url(url.toString() + queryString).headers(header).get().build();
        okhttp3.Call okCall = okHttpClient.newCall(request);
        return this.getResponse(paraMap, okCall);
    }

    private String getQueryString(Map<String, String> paraMap) {
        StringJoiner fromData = new StringJoiner("");
        for (Map.Entry<String, String> entry : paraMap.entrySet()) {
            fromData.add(entry.getKey()).add("=").add(entry.getValue()).add("&");
        }
        String queryString = fromData.toString();
        if (queryString.endsWith("&")) {
            queryString = queryString.substring(0, queryString.length() - 1);
        }
        return queryString;
    }

    private Headers setHeaders(CloudRequest cloudRequest, String queryString) throws CloudException {
        Headers header;
        if (Auth.KEYED == cloudRequest.getAuth()) {
            header = Headers.of((String[])new String[]{"User-Agent", USER_AGENT, "X-BM-KEY", this.cloudContext.getCloudKey().getApiKey()});
        } else if (Auth.SIGNED == cloudRequest.getAuth()) {
            CloudSignature.Signature signature = CloudSignature.create(queryString, this.cloudContext.getCloudKey().getApiSecret(), this.cloudContext.getCloudKey().getMemo());
            header = Headers.of((String[])new String[]{"User-Agent", USER_AGENT, "X-BM-KEY", this.cloudContext.getCloudKey().getApiKey(), "X-BM-TIMESTAMP", signature.getTimestamp(), "X-BM-SIGN", signature.getSign()});
        } else {
            header = Headers.of((String[])new String[]{"User-Agent", USER_AGENT});
        }
        return header;
    }

    private CloudResponse getResponse(Map<String, String> paraMap, okhttp3.Call okCall) throws CloudException {
        try {
            Response response = okCall.execute();
            return new CloudResponse().setResponseContent(response.body().string()).setResponseHttpStatus(response.code()).setCloudLimit(new CloudLimit().setLimit(Integer.parseInt((String)StringUtils.defaultIfBlank((CharSequence)response.header("X-BM-RateLimit-Limit"), (CharSequence)"0"))).setRemaining(Integer.parseInt((String)StringUtils.defaultIfBlank((CharSequence)response.header("X-BM-RateLimit-Remaining"), (CharSequence)"0"))).setReset(Integer.parseInt((String)StringUtils.defaultIfBlank((CharSequence)response.header("X-BM-RateLimit-Reset"), (CharSequence)"0"))));
        }
        catch (IOException var18) {
            throw new CloudException("Error: " + var18.getMessage());
        }
        catch (Exception var19) {
            throw new CloudException("Error: " + var19.getMessage());
        }
    }
}

