/*
 * Decompiled with CFR 0.152.
 */
package com.bitmart.websocket;

import com.bitmart.api.common.CloudException;
import com.bitmart.api.common.JsonUtils;
import com.bitmart.api.key.CloudKey;
import com.bitmart.api.key.CloudSignature;
import com.bitmart.websocket.WebSocketCallBack;
import com.bitmart.websocket.WebSocketClient;
import com.bitmart.websocket.contract.ActionParam;
import com.bitmart.websocket.contract.PingParam;
import com.google.common.collect.ImmutableList;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContractWebSocket
extends WebSocketClient {
    private static final Logger log = LoggerFactory.getLogger(ContractWebSocket.class);

    public ContractWebSocket(String url, WebSocketCallBack callBack) throws CloudException, URISyntaxException, SSLException {
        super(url, null, callBack);
    }

    public ContractWebSocket(String url, CloudKey cloudKey, WebSocketCallBack callBack) throws CloudException, URISyntaxException, SSLException {
        super(url, cloudKey, callBack);
    }

    @Override
    public void login() throws CloudException {
        this.reconnectionUseLogin = true;
        CloudSignature.Signature signature = CloudSignature.create("bitmart.WebSocket", this.cloudKey.getApiSecret(), this.cloudKey.getMemo());
        ActionParam actionParam = new ActionParam().setAction("access").setArgs((List<String>)ImmutableList.of((Object)this.cloudKey.getApiKey(), (Object)signature.getTimestamp(), (Object)signature.getSign(), (Object)"web"));
        String param = JsonUtils.toJson(actionParam);
        if (this.isPrint) {
            log.info("WebSocket Client Send:{}", (Object)param);
        }
        this.clientChannel.writeAndFlush((Object)new TextWebSocketFrame(param));
    }

    @Override
    public void subscribe(List<String> channels) {
        this.reconnectionChannel.addAll(channels);
        ActionParam actionParam = new ActionParam().setAction("subscribe").setArgs(channels);
        String param = JsonUtils.toJson(actionParam);
        if (this.isPrint) {
            log.info("WebSocket Client Send:{}", (Object)param);
        }
        this.clientChannel.writeAndFlush((Object)new TextWebSocketFrame(param));
    }

    @Override
    void keepalive() {
        final Channel channel = this.clientChannel;
        new Timer("WebSocket-Keepalive").schedule(new TimerTask(){

            @Override
            public void run() {
                if (channel.isActive()) {
                    PingParam pingParam = new PingParam().setSubscribe("ping");
                    String param = JsonUtils.toJson(pingParam);
                    if (ContractWebSocket.this.isPrint) {
                        log.info("WebSocket Client Send:{}", (Object)param);
                    }
                    channel.writeAndFlush((Object)new TextWebSocketFrame(param));
                }
            }
        }, 2000L, 10000L);
    }
}

