/*
 * Decompiled with CFR 0.152.
 */
package com.bitmart.api;

import com.bitmart.api.key.CloudKey;

public final class CloudContext {
    private boolean printLog = false;
    private boolean isDebug = false;
    private String cloudUrl;
    private long connectTimeoutMilliSeconds = 2000L;
    private long readTimeoutMilliSeconds = 10000L;
    private long writeTimeoutMilliSeconds = 2000L;
    private CloudKey cloudKey;

    public CloudContext() {
        this.init("https://api-cloud.bitmart.com", new CloudKey());
    }

    public CloudContext(String cloudUrl) {
        this.init(cloudUrl, new CloudKey());
    }

    public CloudContext(CloudKey cloudKey) {
        this.init("https://api-cloud.bitmart.com", cloudKey);
    }

    public CloudContext(String cloudUrl, CloudKey cloudKey) {
        this.init(cloudUrl, cloudKey);
    }

    private void init(String cloudCenterUrl, CloudKey cloudKey) {
        this.cloudKey = cloudKey;
        this.cloudUrl = cloudCenterUrl;
    }

    public boolean isPrintLog() {
        return this.printLog;
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public String getCloudUrl() {
        return this.cloudUrl;
    }

    public long getConnectTimeoutMilliSeconds() {
        return this.connectTimeoutMilliSeconds;
    }

    public long getReadTimeoutMilliSeconds() {
        return this.readTimeoutMilliSeconds;
    }

    public long getWriteTimeoutMilliSeconds() {
        return this.writeTimeoutMilliSeconds;
    }

    public CloudKey getCloudKey() {
        return this.cloudKey;
    }

    public void setPrintLog(boolean printLog) {
        this.printLog = printLog;
    }

    public void setDebug(boolean isDebug) {
        this.isDebug = isDebug;
    }

    public void setCloudUrl(String cloudUrl) {
        this.cloudUrl = cloudUrl;
    }

    public void setConnectTimeoutMilliSeconds(long connectTimeoutMilliSeconds) {
        this.connectTimeoutMilliSeconds = connectTimeoutMilliSeconds;
    }

    public void setReadTimeoutMilliSeconds(long readTimeoutMilliSeconds) {
        this.readTimeoutMilliSeconds = readTimeoutMilliSeconds;
    }

    public void setWriteTimeoutMilliSeconds(long writeTimeoutMilliSeconds) {
        this.writeTimeoutMilliSeconds = writeTimeoutMilliSeconds;
    }

    public void setCloudKey(CloudKey cloudKey) {
        this.cloudKey = cloudKey;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CloudContext)) {
            return false;
        }
        CloudContext other = (CloudContext)o;
        if (this.isPrintLog() != other.isPrintLog()) {
            return false;
        }
        if (this.isDebug() != other.isDebug()) {
            return false;
        }
        if (this.getConnectTimeoutMilliSeconds() != other.getConnectTimeoutMilliSeconds()) {
            return false;
        }
        if (this.getReadTimeoutMilliSeconds() != other.getReadTimeoutMilliSeconds()) {
            return false;
        }
        if (this.getWriteTimeoutMilliSeconds() != other.getWriteTimeoutMilliSeconds()) {
            return false;
        }
        String this$cloudUrl = this.getCloudUrl();
        String other$cloudUrl = other.getCloudUrl();
        if (this$cloudUrl == null ? other$cloudUrl != null : !this$cloudUrl.equals(other$cloudUrl)) {
            return false;
        }
        CloudKey this$cloudKey = this.getCloudKey();
        CloudKey other$cloudKey = other.getCloudKey();
        return !(this$cloudKey == null ? other$cloudKey != null : !((Object)this$cloudKey).equals(other$cloudKey));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPrintLog() ? 79 : 97);
        result = result * 59 + (this.isDebug() ? 79 : 97);
        long $connectTimeoutMilliSeconds = this.getConnectTimeoutMilliSeconds();
        result = result * 59 + (int)($connectTimeoutMilliSeconds >>> 32 ^ $connectTimeoutMilliSeconds);
        long $readTimeoutMilliSeconds = this.getReadTimeoutMilliSeconds();
        result = result * 59 + (int)($readTimeoutMilliSeconds >>> 32 ^ $readTimeoutMilliSeconds);
        long $writeTimeoutMilliSeconds = this.getWriteTimeoutMilliSeconds();
        result = result * 59 + (int)($writeTimeoutMilliSeconds >>> 32 ^ $writeTimeoutMilliSeconds);
        String $cloudUrl = this.getCloudUrl();
        result = result * 59 + ($cloudUrl == null ? 43 : $cloudUrl.hashCode());
        CloudKey $cloudKey = this.getCloudKey();
        result = result * 59 + ($cloudKey == null ? 43 : ((Object)$cloudKey).hashCode());
        return result;
    }

    public String toString() {
        return "CloudContext(printLog=" + this.isPrintLog() + ", isDebug=" + this.isDebug() + ", cloudUrl=" + this.getCloudUrl() + ", connectTimeoutMilliSeconds=" + this.getConnectTimeoutMilliSeconds() + ", readTimeoutMilliSeconds=" + this.getReadTimeoutMilliSeconds() + ", writeTimeoutMilliSeconds=" + this.getWriteTimeoutMilliSeconds() + ", cloudKey=" + this.getCloudKey() + ")";
    }
}

