/*
 * Decompiled with CFR 0.152.
 */
package com.bitmart.websocket;

import com.bitmart.api.common.CloudException;
import com.bitmart.api.common.JsonUtils;
import com.bitmart.api.key.CloudKey;
import com.bitmart.api.key.CloudSignature;
import com.bitmart.websocket.OpParam;
import com.bitmart.websocket.WebSocketCallBack;
import com.bitmart.websocket.WebSocketClientHandler;
import com.google.common.collect.ImmutableList;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.net.ssl.SSLException;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketClient {
    private static final Logger log = LoggerFactory.getLogger(WebSocketClient.class);
    private EventLoopGroup group;
    Channel clientChannel;
    CloudKey cloudKey;
    private SslContext sslContext;
    private URI uri;
    private String host;
    private int port;
    final List<String> reconnectionChannel = new ArrayList<String>();
    boolean reconnectionUseLogin = false;
    boolean isClose = false;
    boolean isSpot = true;
    public WebSocketCallBack callBack;

    public WebSocketClient(WebSocketCallBack callBack) throws CloudException {
        this.init("wss://ws-manager-compress.bitmart.com/api?protocol=1.1", null, callBack);
    }

    public WebSocketClient(CloudKey cloudKey, WebSocketCallBack callBack) throws CloudException {
        this.init("wss://ws-manager-compress.bitmart.com/api?protocol=1.1", cloudKey, callBack);
    }

    public WebSocketClient(String url, WebSocketCallBack callBack) throws CloudException {
        this.init(url, null, callBack);
    }

    public WebSocketClient(String url, CloudKey cloudKey, WebSocketCallBack callBack) throws CloudException {
        this.init(url, cloudKey, callBack);
    }

    private void init(String url, CloudKey cloudKey, WebSocketCallBack callBack) throws CloudException {
        String scheme;
        this.cloudKey = cloudKey;
        this.callBack = callBack;
        try {
            this.uri = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new CloudException("URISyntaxException" + e.getMessage());
        }
        this.host = this.uri.getHost() == null ? "127.0.0.1" : this.uri.getHost();
        String string = scheme = this.uri.getScheme() == null ? "ws" : this.uri.getScheme();
        this.port = this.uri.getPort() == -1 ? ("ws".equalsIgnoreCase(scheme) ? 80 : ("wss".equalsIgnoreCase(scheme) ? 443 : -1)) : this.uri.getPort();
        if (!"ws".equalsIgnoreCase(scheme) && !"wss".equalsIgnoreCase(scheme)) {
            throw new CloudException("Only WS(S) is supported." + url);
        }
        boolean ssl = "wss".equalsIgnoreCase(scheme);
        if (ssl) {
            try {
                this.sslContext = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
            }
            catch (SSLException e) {
                throw new CloudException("SSLException:" + e.getMessage());
            }
        }
        this.connection();
    }

    private void connection() throws CloudException {
        try {
            if (this.group == null) {
                this.group = new NioEventLoopGroup();
            }
            final WebSocketClientHandler handler = new WebSocketClientHandler(WebSocketClientHandshakerFactory.newHandshaker((URI)this.uri, (WebSocketVersion)WebSocketVersion.V13, null, (boolean)false, (HttpHeaders)new DefaultHttpHeaders()), this);
            Bootstrap bootstrap = new Bootstrap();
            ((Bootstrap)((Bootstrap)bootstrap.group(this.group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    ChannelPipeline p = ch.pipeline();
                    if (WebSocketClient.this.sslContext != null) {
                        p.addLast(new ChannelHandler[]{WebSocketClient.this.sslContext.newHandler(ch.alloc(), WebSocketClient.this.host, WebSocketClient.this.port)});
                    }
                    p.addLast(new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(8192), handler});
                }
            });
            this.clientChannel = bootstrap.connect(this.uri.getHost(), this.port).sync().channel();
            handler.handshakeFuture().sync();
            this.keepalive();
        }
        catch (Exception e) {
            throw new CloudException(e.getMessage());
        }
    }

    public void reconnection() {
        try {
            log.info("WebSocket Client Reconnection to {}", (Object)this.uri.toString());
            this.connection();
            if (this.reconnectionUseLogin) {
                this.login();
            }
            if (!CollectionUtils.isEmpty(this.reconnectionChannel)) {
                int count = 0;
                for (String channel : this.reconnectionChannel) {
                    this.clientChannel.writeAndFlush((Object)new TextWebSocketFrame(channel));
                    if (++count % 100 != 0) continue;
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        catch (CloudException e) {
            e.printStackTrace();
        }
    }

    public void login() throws CloudException {
        this.reconnectionUseLogin = true;
        CloudSignature.Signature signature = CloudSignature.create("bitmart.WebSocket", this.cloudKey.getApiSecret(), this.cloudKey.getMemo());
        OpParam opParam = new OpParam().setOp("login").setArgs((List<String>)ImmutableList.of((Object)this.cloudKey.getApiKey(), (Object)signature.getTimestamp(), (Object)signature.getSign()));
        String param = JsonUtils.toJson(opParam);
        log.debug("WebSocket Client Send:{}", (Object)param);
        this.clientChannel.writeAndFlush((Object)new TextWebSocketFrame(param));
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void send(String message) {
        if (!this.reconnectionChannel.contains(message)) {
            this.reconnectionChannel.add(message);
        }
        this.clientChannel.writeAndFlush((Object)new TextWebSocketFrame(message));
    }

    public void send(OpParam opParam) {
        String param = JsonUtils.toJson(opParam);
        if (log.isDebugEnabled()) {
            log.debug("WebSocket Client Send:{}", (Object)param);
        }
        this.send(param);
    }

    void keepalive() {
        final Channel channel = this.clientChannel;
        new Timer("WebSocket-Keepalive").schedule(new TimerTask(){

            @Override
            public void run() {
                if (channel.isActive()) {
                    channel.writeAndFlush((Object)new TextWebSocketFrame("ping"));
                }
            }
        }, 2000L, 10000L);
    }

    public void stop(String reason) {
        log.error("WebSocket Client Stop. reason={}", (Object)reason);
        this.isClose = true;
        this.clientChannel.close();
        this.group.shutdownGracefully();
    }

    public boolean isClose() {
        return this.isClose;
    }
}

