/*
 * Decompiled with CFR 0.152.
 */
package com.bitmart.api;

import com.bitmart.api.CloudContext;
import com.bitmart.api.common.CloudException;
import com.bitmart.api.common.CloudLimit;
import com.bitmart.api.common.CloudResponse;
import com.bitmart.api.common.CommonUtils;
import com.bitmart.api.common.JsonUtils;
import com.bitmart.api.key.CloudSignature;
import com.bitmart.api.request.Auth;
import com.bitmart.api.request.CloudRequest;
import com.bitmart.api.request.Method;
import java.io.IOException;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Call {
    private static final Logger log = LoggerFactory.getLogger(Call.class);
    private final CloudContext cloudContext;
    private final OkHttpClient okHttpClient;
    private static final String USER_AGENT = "bitmart-java-sdk-api/2.3.0";

    private static OkHttpClient createOkHttpClient(CloudContext cloudContext) {
        HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor();
        interceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        return new OkHttpClient.Builder().connectTimeout(cloudContext.getConnectTimeoutMilliSeconds(), TimeUnit.MILLISECONDS).readTimeout(cloudContext.getReadTimeoutMilliSeconds(), TimeUnit.MILLISECONDS).writeTimeout(cloudContext.getWriteTimeoutMilliSeconds(), TimeUnit.MILLISECONDS).build();
    }

    public Call(CloudContext cloudContext) {
        this.cloudContext = cloudContext;
        this.okHttpClient = Call.createOkHttpClient(cloudContext);
    }

    public CloudResponse callCloud(CloudRequest cloudRequest) throws CloudException {
        return Method.POST.equals((Object)cloudRequest.getMethod()) ? this.post(cloudRequest) : this.get(cloudRequest);
    }

    private CloudResponse post(CloudRequest cloudRequest) throws CloudException {
        if (cloudRequest == null) {
            throw new CloudException("request can not null");
        }
        Map<String, Object> paraMap = CommonUtils.genRequestMap(cloudRequest);
        String json = JsonUtils.toJson(paraMap);
        MediaType parse = MediaType.Companion.parse("application/json; charset=utf-8");
        RequestBody requestBody = RequestBody.Companion.create(json, parse);
        Headers header = this.setHeaders(cloudRequest, json, this.cloudContext.getCustomHeaders());
        if (log.isDebugEnabled()) {
            log.debug("URL:{}\nHeader:{}\nBody:{}", new Object[]{this.cloudContext.getCloudUrl() + cloudRequest.getPath(), header.toMultimap(), json});
        }
        Request request = new Request.Builder().url(this.cloudContext.getCloudUrl() + cloudRequest.getPath()).headers(header).post(requestBody).build();
        okhttp3.Call okCall = this.okHttpClient.newCall(request);
        return this.getResponse(okCall);
    }

    private CloudResponse get(CloudRequest cloudRequest) throws CloudException {
        if (cloudRequest == null) {
            throw new CloudException("request can not null");
        }
        StringJoiner url = new StringJoiner("");
        Map<String, Object> paraMap = CommonUtils.genRequestMap(cloudRequest);
        url.add(this.cloudContext.getCloudUrl() + cloudRequest.getPath());
        if (!paraMap.isEmpty()) {
            url.add("?");
        }
        String queryString = this.getQueryString(paraMap);
        if (log.isDebugEnabled()) {
            log.debug("URL:{}", (Object)(url + queryString));
        }
        Headers header = this.setHeaders(cloudRequest, queryString, this.cloudContext.getCustomHeaders());
        Request request = new Request.Builder().url(url.toString() + queryString).headers(header).get().build();
        okhttp3.Call okCall = this.okHttpClient.newCall(request);
        return this.getResponse(okCall);
    }

    private String getQueryString(Map<String, Object> paraMap) {
        StringJoiner fromData = new StringJoiner("");
        for (Map.Entry<String, Object> entry : paraMap.entrySet()) {
            fromData.add(entry.getKey()).add("=").add(entry.getValue().toString()).add("&");
        }
        String queryString = fromData.toString();
        if (queryString.endsWith("&")) {
            queryString = queryString.substring(0, queryString.length() - 1);
        }
        return queryString;
    }

    private Headers setHeaders(CloudRequest cloudRequest, String queryString, Map<String, String> customHeaders) throws CloudException {
        Headers.Builder headerBuilder = new Headers.Builder();
        headerBuilder.add("User-Agent", USER_AGENT);
        if (Auth.KEYED == cloudRequest.getAuth()) {
            headerBuilder.add("X-BM-KEY", this.cloudContext.getCloudKey().getApiKey());
        } else if (Auth.SIGNED == cloudRequest.getAuth()) {
            CloudSignature.Signature signature = CloudSignature.create(queryString, this.cloudContext.getCloudKey().getApiSecret(), this.cloudContext.getCloudKey().getMemo());
            headerBuilder.add("X-BM-KEY", this.cloudContext.getCloudKey().getApiKey());
            headerBuilder.add("X-BM-TIMESTAMP", signature.getTimestamp());
            headerBuilder.add("X-BM-SIGN", signature.getSign());
        }
        if (customHeaders != null && !customHeaders.isEmpty()) {
            for (Map.Entry<String, String> entry : customHeaders.entrySet()) {
                headerBuilder.add(entry.getKey(), entry.getValue());
            }
        }
        return headerBuilder.build();
    }

    private CloudResponse getResponse(okhttp3.Call okCall) throws CloudException {
        try {
            Response response = okCall.execute();
            CloudResponse cloudResponse = new CloudResponse().setResponseContent(response.body().string()).setResponseHttpStatus(response.code()).setCloudLimit(new CloudLimit().setLimit(CommonUtils.getRateLimitValue(response.header("X-BM-RateLimit-Limit"))).setRemaining(CommonUtils.getRateLimitValue(response.header("X-BM-RateLimit-Remaining"))).setReset(CommonUtils.getRateLimitValue(response.header("X-BM-RateLimit-Reset"))).setMode(response.header("X-BM-RateLimit-Mode")));
            if (log.isDebugEnabled()) {
                log.debug("Response:{}", (Object)cloudResponse);
            }
            return cloudResponse;
        }
        catch (IOException var18) {
            throw new CloudException("Error: " + var18.getMessage());
        }
        catch (Exception var19) {
            throw new CloudException("Error: " + var19.getMessage());
        }
    }
}

