/*
 * Decompiled with CFR 0.152.
 */
package com.bitmart.api.common;

import com.bitmart.api.annotations.ParamKey;
import com.bitmart.api.common.CloudException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommonUtils {
    private static final Logger log = LoggerFactory.getLogger(CommonUtils.class);

    public static Map<String, Object> genRequestMap(Object cloudRequest) throws CloudException {
        if (cloudRequest == null) {
            return new TreeMap<String, Object>();
        }
        TreeMap<String, Object> paraMap = new TreeMap<String, Object>();
        try {
            Field[] declaredFields = cloudRequest.getClass().getDeclaredFields();
            if (declaredFields.length == 0) {
                return new TreeMap<String, Object>();
            }
            List collect = Arrays.stream(declaredFields).collect(Collectors.toList());
            for (Field declaredField : collect) {
                declaredField.setAccessible(true);
                ParamKey paramKey = declaredField.getAnnotation(ParamKey.class);
                if (paramKey == null) continue;
                String key = paramKey.value();
                Object value = declaredField.get(cloudRequest);
                if (paramKey.required() && value == null) {
                    throw new CloudException("The request parameter [" + declaredField.getName() + "] is required");
                }
                if (value == null) continue;
                paraMap.put(key, value);
            }
        }
        catch (Exception ex) {
            throw new CloudException(ex.getMessage());
        }
        return paraMap;
    }

    public static int getRateLimitValue(String val) {
        try {
            return Integer.parseInt((String)StringUtils.defaultIfBlank((CharSequence)val, (CharSequence)"0"));
        }
        catch (Exception e) {
            log.warn("getRateLimitValue value={}", (Object)val);
            return 0;
        }
    }
}

