/*
 * Decompiled with CFR 0.152.
 */
package com.github.codeboyzhou.mcp.declarative.listener;

import com.github.codeboyzhou.mcp.declarative.listener.McpHttpServerStatusListener;
import io.modelcontextprotocol.server.McpSyncServer;
import io.modelcontextprotocol.spec.McpSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMcpSyncHttpServerStatusListener
implements McpHttpServerStatusListener<McpSyncServer> {
    private static final Logger logger = LoggerFactory.getLogger(DefaultMcpSyncHttpServerStatusListener.class);

    @Override
    public void onStarted(McpSyncServer mcpServer) {
        McpSchema.Implementation serverInfo = mcpServer.getServerInfo();
        logger.info("MCP server [{}] {} started successfully in HTTP SSE mode", (Object)serverInfo.name(), (Object)serverInfo.version());
    }

    @Override
    public void onStopped(McpSyncServer mcpServer) {
        mcpServer.closeGracefully();
        McpSchema.Implementation serverInfo = mcpServer.getServerInfo();
        logger.info("MCP server [{}] {} closed gracefully", (Object)serverInfo.name(), (Object)serverInfo.version());
    }

    @Override
    public void onError(McpSyncServer mcpServer, Throwable throwable) {
        mcpServer.close();
        McpSchema.Implementation serverInfo = mcpServer.getServerInfo();
        logger.info("MCP server [{}] {} closed", (Object)serverInfo.name(), (Object)serverInfo.version());
    }
}

