/*
 * Decompiled with CFR 0.152.
 */
package com.github.codeboyzhou.mcp.declarative.server;

import com.github.codeboyzhou.mcp.declarative.listener.McpHttpServerStatusListener;
import com.github.codeboyzhou.mcp.declarative.server.McpSseServerInfo;
import io.modelcontextprotocol.server.transport.HttpServletSseServerTransportProvider;
import io.modelcontextprotocol.util.Assert;
import jakarta.servlet.Servlet;
import java.time.Duration;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class McpHttpServer<T> {
    private static final Logger logger = LoggerFactory.getLogger(McpHttpServer.class);
    private static final String DEFAULT_SERVLET_CONTEXT_PATH = "/";
    private static final String DEFAULT_SERVLET_PATH = "/*";
    private HttpServletSseServerTransportProvider transportProvider;
    private McpSseServerInfo serverInfo;
    private McpHttpServerStatusListener<T> statusListener;
    private T mcpServer;

    public McpHttpServer<T> with(HttpServletSseServerTransportProvider transportProvider) {
        Assert.notNull((Object)transportProvider, (String)"transportProvider cannot be null");
        this.transportProvider = transportProvider;
        return this;
    }

    public McpHttpServer<T> with(McpSseServerInfo serverInfo) {
        Assert.notNull((Object)serverInfo, (String)"serverInfo cannot be null");
        this.serverInfo = serverInfo;
        return this;
    }

    public McpHttpServer<T> with(McpHttpServerStatusListener<T> statusListener) {
        Assert.notNull(statusListener, (String)"statusListener cannot be null");
        this.statusListener = statusListener;
        return this;
    }

    public McpHttpServer<T> attach(T mcpServer) {
        Assert.notNull(mcpServer, (String)"mcpServer cannot be null");
        this.mcpServer = mcpServer;
        return this;
    }

    public void start() {
        ServletContextHandler handler = new ServletContextHandler(1);
        handler.setContextPath(DEFAULT_SERVLET_CONTEXT_PATH);
        ServletHolder servletHolder = new ServletHolder((Servlet)this.transportProvider);
        handler.addServlet(servletHolder, DEFAULT_SERVLET_PATH);
        Server httpserver = new Server(this.serverInfo.port());
        httpserver.setHandler((Handler)handler);
        httpserver.setStopAtShutdown(true);
        httpserver.setStopTimeout(Duration.ofSeconds(5L).getSeconds());
        try {
            httpserver.start();
            logger.info("Jetty-based HTTP server started on http://127.0.0.1:{}", (Object)this.serverInfo.port());
            this.statusListener.onStarted(this.mcpServer);
            this.addShutdownHook(httpserver);
            boolean testing = Boolean.parseBoolean(System.getProperty("mcp.declarative.java.sdk.testing"));
            if (testing) {
                logger.debug("Jetty-based HTTP server is running in test mode, not waiting for HTTP server to stop");
                return;
            }
            httpserver.join();
        }
        catch (Exception e) {
            logger.error("Error starting HTTP server on http://127.0.0.1:{}", (Object)this.serverInfo.port(), (Object)e);
            this.statusListener.onError(this.mcpServer, e);
        }
    }

    private void addShutdownHook(Server httpserver) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                logger.info("Shutting down HTTP server and MCP server");
                httpserver.stop();
                this.statusListener.onStopped(this.mcpServer);
            }
            catch (Exception e) {
                logger.error("Error stopping HTTP server and MCP server", (Throwable)e);
            }
        }));
    }
}

