/*
 * Decompiled with CFR 0.152.
 */
package com.github.codeboyzhou.mcp.declarative.server;

import com.github.codeboyzhou.mcp.declarative.annotation.McpPrompt;
import com.github.codeboyzhou.mcp.declarative.annotation.McpPromptParam;
import com.github.codeboyzhou.mcp.declarative.server.McpServerComponentRegister;
import com.github.codeboyzhou.mcp.declarative.util.ReflectionHelper;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.server.McpSyncServer;
import io.modelcontextprotocol.spec.McpSchema;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class McpSyncServerPromptRegister
implements McpServerComponentRegister<McpSyncServer, McpServerFeatures.SyncPromptSpecification> {
    private static final Logger logger = LoggerFactory.getLogger(McpSyncServerPromptRegister.class);
    private final Set<Class<?>> promptClasses;

    public McpSyncServerPromptRegister(Set<Class<?>> promptClasses) {
        this.promptClasses = promptClasses;
    }

    @Override
    public void registerTo(McpSyncServer server) {
        for (Class<?> promptClass : this.promptClasses) {
            Set<Method> methods = ReflectionHelper.getMethodsAnnotatedWith(promptClass, McpPrompt.class);
            for (Method method : methods) {
                McpServerFeatures.SyncPromptSpecification prompt = this.createComponentFrom(promptClass, method);
                server.addPrompt(prompt);
            }
        }
    }

    @Override
    public McpServerFeatures.SyncPromptSpecification createComponentFrom(Class<?> clazz, Method method) {
        McpPrompt promptMethod = method.getAnnotation(McpPrompt.class);
        String name = promptMethod.name().isBlank() ? method.getName() : promptMethod.name();
        String description = promptMethod.description();
        List<McpSchema.PromptArgument> promptArguments = this.createPromptArguments(method);
        McpSchema.Prompt prompt = new McpSchema.Prompt(name, description, promptArguments);
        return new McpServerFeatures.SyncPromptSpecification(prompt, (exchange, request) -> {
            Object result;
            try {
                result = ReflectionHelper.invokeMethod(clazz, method, request.arguments());
            }
            catch (Throwable e) {
                logger.error("Error invoking prompt method", e);
                result = String.valueOf(e) + ": " + e.getMessage();
            }
            McpSchema.TextContent content = new McpSchema.TextContent(result.toString());
            McpSchema.PromptMessage message = new McpSchema.PromptMessage(McpSchema.Role.USER, (McpSchema.Content)content);
            return new McpSchema.GetPromptResult(description, List.of(message));
        });
    }

    private List<McpSchema.PromptArgument> createPromptArguments(Method method) {
        Set<Parameter> parameters = ReflectionHelper.getParametersAnnotatedWith(method, McpPromptParam.class);
        ArrayList<McpSchema.PromptArgument> promptArguments = new ArrayList<McpSchema.PromptArgument>(parameters.size());
        for (Parameter parameter : parameters) {
            McpPromptParam promptParam = parameter.getAnnotation(McpPromptParam.class);
            String name = promptParam.name();
            String description = promptParam.description();
            boolean required = promptParam.required();
            McpSchema.PromptArgument promptArgument = new McpSchema.PromptArgument(name, description, Boolean.valueOf(required));
            promptArguments.add(promptArgument);
        }
        return promptArguments;
    }
}

