/*
 * Decompiled with CFR 0.152.
 */
package com.github.codeboyzhou.mcp.declarative.util;

import io.modelcontextprotocol.spec.McpSchema;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class ReflectionHelper {
    public static Set<Method> getMethodsAnnotatedWith(Class<?> clazz, Class<? extends Annotation> annotation) {
        Method[] methods = clazz.getMethods();
        return Set.of(methods).stream().filter(m -> m.isAnnotationPresent(annotation)).collect(Collectors.toSet());
    }

    public static Set<Parameter> getParametersAnnotatedWith(Method method, Class<? extends Annotation> annotation) {
        Parameter[] parameters = method.getParameters();
        return Set.of(parameters).stream().filter(p -> p.isAnnotationPresent(annotation)).collect(Collectors.toSet());
    }

    public static Object invokeMethod(Class<?> clazz, Method method) throws Exception {
        Object object = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        return method.invoke(object, new Object[0]);
    }

    public static Object invokeMethod(Class<?> clazz, Method method, Map<String, Object> parameters) throws Exception {
        Object object = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        return method.invoke(object, parameters.values().toArray());
    }

    public static Object invokeMethod(Class<?> clazz, Method method, McpSchema.JsonSchema schema, Map<String, Object> parameters) throws Exception {
        Object object = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Map<String, Object> typedParameters = ReflectionHelper.asTypedParameters(schema, parameters);
        return method.invoke(object, typedParameters.values().toArray());
    }

    private static Map<String, Object> asTypedParameters(McpSchema.JsonSchema schema, Map<String, Object> parameters) {
        Map properties = schema.properties();
        LinkedHashMap<String, Object> typedParameters = new LinkedHashMap<String, Object>(properties.size());
        properties.forEach((parameterName, parameterProperties) -> {
            Object parameterValue = parameters.get(parameterName);
            if (parameterValue == null) {
                Map map = (Map)parameterProperties;
                String parameterType = map.get("type").toString();
                if (ReflectionHelper.isTypeOf(String.class, parameterType)) {
                    typedParameters.put((String)parameterName, "");
                } else if (ReflectionHelper.isTypeOf(Integer.class, parameterType)) {
                    typedParameters.put((String)parameterName, 0);
                } else if (ReflectionHelper.isTypeOf(Number.class, parameterType)) {
                    typedParameters.put((String)parameterName, 0.0);
                } else if (ReflectionHelper.isTypeOf(Boolean.class, parameterType)) {
                    typedParameters.put((String)parameterName, false);
                }
            } else {
                typedParameters.put((String)parameterName, parameterValue);
            }
        });
        return typedParameters;
    }

    private static boolean isTypeOf(Class<?> clazz, String jsonSchemaType) {
        return clazz.getName().equalsIgnoreCase(jsonSchemaType) || clazz.getSimpleName().equalsIgnoreCase(jsonSchemaType);
    }
}

