/*
 * Decompiled with CFR 0.152.
 */
package com.github.codeboyzhou.mcp.declarative.di;

import com.github.codeboyzhou.mcp.declarative.di.DependencyInjector;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;

public class GuiceDependencyInjector
implements DependencyInjector {
    private final Injector injector;

    public GuiceDependencyInjector(Injector injector) {
        this.injector = injector;
    }

    @Override
    public <T> T getInstance(Class<T> type) {
        if (this.isInitialized()) {
            return (T)this.injector.getInstance(type);
        }
        throw new IllegalStateException("GuiceDependencyInjector is not initialized");
    }

    @Override
    public <T> T getVariable(Class<T> type, String name) {
        if (this.isInitialized()) {
            return (T)this.injector.getInstance(Key.get(type, (Annotation)Names.named((String)name)));
        }
        throw new IllegalStateException("GuiceDependencyInjector is not initialized");
    }

    @Override
    public boolean isInitialized() {
        return this.injector != null;
    }
}

