/*
 * Decompiled with CFR 0.152.
 */
package com.github.codeboyzhou.mcp.declarative.di;

import com.github.codeboyzhou.mcp.declarative.annotation.McpI18nEnabled;
import com.github.codeboyzhou.mcp.declarative.annotation.McpPrompt;
import com.github.codeboyzhou.mcp.declarative.annotation.McpResource;
import com.github.codeboyzhou.mcp.declarative.annotation.McpServerApplication;
import com.github.codeboyzhou.mcp.declarative.annotation.McpTool;
import com.github.codeboyzhou.mcp.declarative.server.McpSseServer;
import com.github.codeboyzhou.mcp.declarative.server.McpStdioServer;
import com.github.codeboyzhou.mcp.declarative.server.McpStreamableServer;
import com.github.codeboyzhou.mcp.declarative.server.component.McpServerPrompt;
import com.github.codeboyzhou.mcp.declarative.server.component.McpServerResource;
import com.github.codeboyzhou.mcp.declarative.server.component.McpServerTool;
import com.github.codeboyzhou.mcp.declarative.server.converter.McpPromptParameterConverter;
import com.github.codeboyzhou.mcp.declarative.server.converter.McpToolParameterConverter;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.stream.Collectors;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;

public final class GuiceInjectorModule
extends AbstractModule {
    public static final String INJECTED_VARIABLE_NAME_I18N_ENABLED = "i18nEnabled";
    private final Class<?> mainClass;

    public GuiceInjectorModule(Class<?> mainClass) {
        this.mainClass = mainClass;
    }

    protected void configure() {
        this.bindClassesOfMethodsAnnotatedWith(McpResource.class);
        this.bindClassesOfMethodsAnnotatedWith(McpPrompt.class);
        this.bindClassesOfMethodsAnnotatedWith(McpTool.class);
        this.bind(McpServerResource.class).in(Scopes.SINGLETON);
        this.bind(McpServerPrompt.class).in(Scopes.SINGLETON);
        this.bind(McpServerTool.class).in(Scopes.SINGLETON);
        this.bind(McpPromptParameterConverter.class).in(Scopes.SINGLETON);
        this.bind(McpToolParameterConverter.class).in(Scopes.SINGLETON);
        this.bind(McpStdioServer.class).in(Scopes.SINGLETON);
        this.bind(McpSseServer.class).in(Scopes.SINGLETON);
        this.bind(McpStreamableServer.class).in(Scopes.SINGLETON);
        boolean i18nEnabled = this.mainClass.isAnnotationPresent(McpI18nEnabled.class);
        this.bind(Boolean.class).annotatedWith((Annotation)Names.named((String)INJECTED_VARIABLE_NAME_I18N_ENABLED)).toInstance((Object)i18nEnabled);
    }

    @Provides
    @Singleton
    public Reflections provideReflections() {
        McpServerApplication application = this.mainClass.getAnnotation(McpServerApplication.class);
        String basePackage = this.determineBasePackage(application);
        return new Reflections(basePackage, new Scanner[]{Scanners.MethodsAnnotated, Scanners.FieldsAnnotated});
    }

    private String determineBasePackage(McpServerApplication application) {
        if (application != null) {
            if (!application.basePackage().trim().isBlank()) {
                return application.basePackage();
            }
            if (application.basePackageClass() != Object.class) {
                return application.basePackageClass().getPackageName();
            }
        }
        return this.mainClass.getPackageName();
    }

    private void bindClassesOfMethodsAnnotatedWith(Class<? extends Annotation> annotation) {
        Reflections reflections = this.provideReflections();
        Set methods = reflections.getMethodsAnnotatedWith(annotation);
        Set<Class> classes = methods.stream().map(Method::getDeclaringClass).collect(Collectors.toSet());
        classes.forEach(clazz -> this.bind((Class)clazz).in(Scopes.SINGLETON));
    }
}

