/*
 * Decompiled with CFR 0.152.
 */
package com.github.codeboyzhou.mcp.declarative.reflect;

import com.github.codeboyzhou.mcp.declarative.reflect.MethodMetadata;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ReflectionCache {
    INSTANCE;

    private static final Logger log;
    private final ConcurrentHashMap<Method, MethodMetadata> methodCache = new ConcurrentHashMap();

    public MethodMetadata getMethodMetadata(Method method) {
        return this.methodCache.computeIfAbsent(method, m -> {
            String className = m.getDeclaringClass().getName();
            log.debug("Caching method metadata for method: {}.{}", (Object)className, (Object)m.getName());
            return MethodMetadata.of(m);
        });
    }

    public boolean isCached(Method method) {
        return this.methodCache.containsKey(method);
    }

    static {
        log = LoggerFactory.getLogger(ReflectionCache.class);
    }
}

