/*
 * Decompiled with CFR 0.152.
 */
package com.github.codeboyzhou.mcp.declarative.server.component;

import com.github.codeboyzhou.mcp.declarative.annotation.McpPrompt;
import com.github.codeboyzhou.mcp.declarative.annotation.McpResource;
import com.github.codeboyzhou.mcp.declarative.annotation.McpTool;
import com.github.codeboyzhou.mcp.declarative.common.Immutable;
import com.github.codeboyzhou.mcp.declarative.di.DependencyInjector;
import com.github.codeboyzhou.mcp.declarative.di.DependencyInjectorProvider;
import com.github.codeboyzhou.mcp.declarative.server.component.McpServerComponent;
import com.github.codeboyzhou.mcp.declarative.server.component.McpServerPrompt;
import com.github.codeboyzhou.mcp.declarative.server.component.McpServerResource;
import com.github.codeboyzhou.mcp.declarative.server.component.McpServerTool;
import io.modelcontextprotocol.server.McpSyncServer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.function.BiConsumer;
import org.reflections.Reflections;

public final class McpServerComponentRegister {
    private final DependencyInjector injector = DependencyInjectorProvider.INSTANCE.getInjector();
    private final Reflections reflections = this.injector.getInstance(Reflections.class);
    private final Immutable<McpSyncServer> server;

    public McpServerComponentRegister(McpSyncServer server) {
        this.server = Immutable.of(server);
    }

    public static McpServerComponentRegister of(McpSyncServer server) {
        return new McpServerComponentRegister(server);
    }

    public void registerComponents() {
        this.register(McpResource.class, McpServerResource.class, McpSyncServer::addResource);
        this.register(McpPrompt.class, McpServerPrompt.class, McpSyncServer::addPrompt);
        this.register(McpTool.class, McpServerTool.class, McpSyncServer::addTool);
    }

    private <T> void register(Class<? extends Annotation> annotationClass, Class<? extends McpServerComponent<T>> componentClass, BiConsumer<McpSyncServer, T> serverAddComponent) {
        Set methods = this.reflections.getMethodsAnnotatedWith(annotationClass);
        McpServerComponent<T> component = this.injector.getInstance(componentClass);
        for (Method method : methods) {
            serverAddComponent.accept(this.server.get(), (McpSyncServer)component.create(method));
        }
    }
}

