/*
 * Decompiled with CFR 0.152.
 */
package com.github.codeboyzhou.mcp.declarative.server.component;

import com.github.codeboyzhou.mcp.declarative.annotation.McpPrompt;
import com.github.codeboyzhou.mcp.declarative.annotation.McpPromptParam;
import com.github.codeboyzhou.mcp.declarative.reflect.MethodMetadata;
import com.github.codeboyzhou.mcp.declarative.reflect.ReflectionCache;
import com.github.codeboyzhou.mcp.declarative.server.component.AbstractMcpServerComponent;
import com.github.codeboyzhou.mcp.declarative.server.converter.McpPromptParameterConverter;
import com.github.codeboyzhou.mcp.declarative.util.ObjectMappers;
import com.github.codeboyzhou.mcp.declarative.util.Strings;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.server.McpSyncServerExchange;
import io.modelcontextprotocol.spec.McpSchema;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class McpServerPrompt
extends AbstractMcpServerComponent<McpServerFeatures.SyncPromptSpecification, McpSchema.GetPromptRequest, McpSchema.GetPromptResult> {
    private static final Logger log = LoggerFactory.getLogger(McpServerPrompt.class);
    private final McpPromptParameterConverter converter;
    private Object instance;

    public McpServerPrompt() {
        this.converter = this.injector.getInstance(McpPromptParameterConverter.class);
    }

    @Override
    public McpServerFeatures.SyncPromptSpecification create(Method method) {
        MethodMetadata methodCache = ReflectionCache.INSTANCE.getMethodMetadata(method);
        this.instance = this.injector.getInstance(methodCache.getDeclaringClass());
        McpPrompt promptMethod = methodCache.getMcpPromptAnnotation();
        String name = Strings.defaultIfBlank(promptMethod.name(), methodCache.getMethodName());
        String title = this.resolveComponentAttributeValue(promptMethod.title());
        String description = this.resolveComponentAttributeValue(promptMethod.description());
        List<McpSchema.PromptArgument> promptArgs = this.createPromptArguments(methodCache.getParameters());
        McpSchema.Prompt prompt = new McpSchema.Prompt(name, title, description, promptArgs);
        log.debug("Registering prompt: {} (Cached: {})", (Object)ObjectMappers.toJson(prompt), (Object)ReflectionCache.INSTANCE.isCached(method));
        return new McpServerFeatures.SyncPromptSpecification(prompt, (exchange, request) -> this.invoke(method, description, (McpSyncServerExchange)exchange, (McpSchema.GetPromptRequest)request));
    }

    @Override
    public McpSchema.GetPromptResult invoke(Method method, String description, McpSyncServerExchange exchange, McpSchema.GetPromptRequest request) {
        Object result;
        MethodMetadata methodCache = ReflectionCache.INSTANCE.getMethodMetadata(method);
        try {
            Map arguments = request.arguments();
            List<Object> convertedParams = this.converter.convertAllParameters(methodCache, arguments);
            result = methodCache.getMethod().invoke(this.instance, convertedParams.toArray());
        }
        catch (Exception e) {
            log.error("Error invoking prompt method: {}", (Object)methodCache.getMethodSignature(), (Object)e);
            result = String.valueOf(e) + ": " + e.getMessage();
        }
        McpSchema.TextContent content = new McpSchema.TextContent(result.toString());
        McpSchema.PromptMessage message = new McpSchema.PromptMessage(McpSchema.Role.USER, (McpSchema.Content)content);
        return new McpSchema.GetPromptResult(description, List.of(message));
    }

    private List<McpSchema.PromptArgument> createPromptArguments(Parameter[] methodParams) {
        ArrayList<McpSchema.PromptArgument> promptArguments = new ArrayList<McpSchema.PromptArgument>(methodParams.length);
        for (Parameter param : methodParams) {
            if (!param.isAnnotationPresent(McpPromptParam.class)) continue;
            McpPromptParam promptParam = param.getAnnotation(McpPromptParam.class);
            String name = promptParam.name();
            String title = this.resolveComponentAttributeValue(promptParam.title());
            String description = this.resolveComponentAttributeValue(promptParam.description());
            boolean required = promptParam.required();
            promptArguments.add(new McpSchema.PromptArgument(name, title, description, Boolean.valueOf(required)));
        }
        return promptArguments;
    }
}

