/*
 * Decompiled with CFR 0.152.
 */
package com.github.codeboyzhou.mcp.declarative.server.component;

import com.github.codeboyzhou.mcp.declarative.annotation.McpResource;
import com.github.codeboyzhou.mcp.declarative.reflect.MethodMetadata;
import com.github.codeboyzhou.mcp.declarative.reflect.ReflectionCache;
import com.github.codeboyzhou.mcp.declarative.server.component.AbstractMcpServerComponent;
import com.github.codeboyzhou.mcp.declarative.util.ObjectMappers;
import com.github.codeboyzhou.mcp.declarative.util.Strings;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.server.McpSyncServerExchange;
import io.modelcontextprotocol.spec.McpSchema;
import java.lang.reflect.Method;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class McpServerResource
extends AbstractMcpServerComponent<McpServerFeatures.SyncResourceSpecification, McpSchema.ReadResourceRequest, McpSchema.ReadResourceResult> {
    private static final Logger log = LoggerFactory.getLogger(McpServerResource.class);
    private Object instance;
    private McpSchema.Resource resource;

    @Override
    public McpServerFeatures.SyncResourceSpecification create(Method method) {
        MethodMetadata methodCache = ReflectionCache.INSTANCE.getMethodMetadata(method);
        this.instance = this.injector.getInstance(methodCache.getDeclaringClass());
        McpResource res = methodCache.getMcpResourceAnnotation();
        String name = Strings.defaultIfBlank(res.name(), methodCache.getMethodName());
        String title = this.resolveComponentAttributeValue(res.title());
        String description = this.resolveComponentAttributeValue(res.description());
        this.resource = McpSchema.Resource.builder().uri(res.uri()).name(name).title(title).description(description).mimeType(res.mimeType()).annotations(new McpSchema.Annotations(List.of(res.roles()), Double.valueOf(res.priority()))).build();
        log.debug("Registering resource: {} (Cached: {})", (Object)ObjectMappers.toJson(this.resource), (Object)ReflectionCache.INSTANCE.isCached(method));
        return new McpServerFeatures.SyncResourceSpecification(this.resource, (exchange, request) -> this.invoke(method, description, (McpSyncServerExchange)exchange, (McpSchema.ReadResourceRequest)request));
    }

    @Override
    public McpSchema.ReadResourceResult invoke(Method method, String description, McpSyncServerExchange exchange, McpSchema.ReadResourceRequest request) {
        Object result;
        MethodMetadata methodCache = ReflectionCache.INSTANCE.getMethodMetadata(method);
        try {
            result = methodCache.getMethod().invoke(this.instance, new Object[0]);
        }
        catch (Exception e) {
            log.error("Error invoking resource method: {}", (Object)methodCache.getMethodSignature(), (Object)e);
            result = String.valueOf(e) + ": " + e.getMessage();
        }
        McpSchema.TextResourceContents contents = new McpSchema.TextResourceContents(this.resource.uri(), this.resource.mimeType(), result.toString());
        return new McpSchema.ReadResourceResult(List.of(contents));
    }
}

