/*
 * Decompiled with CFR 0.152.
 */
package com.github.codeboyzhou.mcp.declarative.server.configurable;

import com.github.codeboyzhou.mcp.declarative.configuration.McpServerCapabilities;
import com.github.codeboyzhou.mcp.declarative.configuration.McpServerChangeNotification;
import com.github.codeboyzhou.mcp.declarative.configuration.McpServerConfiguration;
import com.github.codeboyzhou.mcp.declarative.server.component.McpServerComponentRegister;
import com.github.codeboyzhou.mcp.declarative.server.configurable.ConfigurableMcpServer;
import io.modelcontextprotocol.server.McpSyncServer;
import io.modelcontextprotocol.spec.McpSchema;
import java.time.Duration;

public abstract class AbstractConfigurableMcpServer
implements ConfigurableMcpServer {
    protected final McpServerConfiguration configuration;

    protected AbstractConfigurableMcpServer(McpServerConfiguration configuration) {
        this.configuration = configuration;
    }

    public void startServer() {
        McpSyncServer server = this.sync().serverInfo(this.configuration.name(), this.configuration.version()).capabilities(this.serverCapabilities()).instructions(this.configuration.instructions()).requestTimeout(Duration.ofMillis(this.configuration.requestTimeout())).build();
        McpServerComponentRegister.of(server).registerComponents();
    }

    private McpSchema.ServerCapabilities serverCapabilities() {
        McpSchema.ServerCapabilities.Builder capabilities = McpSchema.ServerCapabilities.builder();
        McpServerCapabilities capabilitiesConfig = this.configuration.capabilities();
        McpServerChangeNotification serverChangeNotification = this.configuration.changeNotification();
        if (capabilitiesConfig.resource()) {
            capabilities.resources(Boolean.valueOf(true), Boolean.valueOf(serverChangeNotification.resource()));
        }
        if (capabilitiesConfig.prompt()) {
            capabilities.prompts(Boolean.valueOf(serverChangeNotification.prompt()));
        }
        if (capabilitiesConfig.tool()) {
            capabilities.tools(Boolean.valueOf(serverChangeNotification.tool()));
        }
        return capabilities.build();
    }
}

