/*
 * Decompiled with CFR 0.152.
 */
package com.github.codeboyzhou.mcp.declarative.server.configurable;

import com.github.codeboyzhou.mcp.declarative.configuration.McpServerConfiguration;
import com.github.codeboyzhou.mcp.declarative.configuration.McpServerStreamable;
import com.github.codeboyzhou.mcp.declarative.server.EmbeddedJettyServer;
import com.github.codeboyzhou.mcp.declarative.server.configurable.AbstractConfigurableMcpServer;
import com.github.codeboyzhou.mcp.declarative.util.ObjectMappers;
import io.modelcontextprotocol.server.McpServer;
import io.modelcontextprotocol.server.transport.HttpServletStreamableServerTransportProvider;
import io.modelcontextprotocol.spec.McpStreamableServerTransportProvider;
import jakarta.servlet.http.HttpServlet;
import java.time.Duration;

public class ConfigurableMcpStreamableServer
extends AbstractConfigurableMcpServer {
    public ConfigurableMcpStreamableServer(McpServerConfiguration configuration) {
        super(configuration);
    }

    @Override
    public McpServer.SyncSpecification<?> sync() {
        McpServerStreamable streamable = this.configuration.streamable();
        HttpServletStreamableServerTransportProvider transportProvider = HttpServletStreamableServerTransportProvider.builder().objectMapper(ObjectMappers.JSON_MAPPER).mcpEndpoint(streamable.mcpEndpoint()).disallowDelete(streamable.disallowDelete()).keepAliveInterval(Duration.ofMillis(streamable.keepAliveInterval())).build();
        EmbeddedJettyServer httpserver = new EmbeddedJettyServer();
        httpserver.use((HttpServlet)transportProvider).bind(streamable.port()).start();
        return McpServer.sync((McpStreamableServerTransportProvider)transportProvider);
    }
}

