/*
 * Decompiled with CFR 0.152.
 */
package com.github.codeboyzhou.mcp.declarative.reflect;

import com.github.codeboyzhou.mcp.declarative.annotation.McpPrompt;
import com.github.codeboyzhou.mcp.declarative.annotation.McpResource;
import com.github.codeboyzhou.mcp.declarative.annotation.McpTool;
import com.github.codeboyzhou.mcp.declarative.common.Immutable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Objects;

public final class MethodMetadata {
    private final Immutable<Method> method;
    private final String methodName;
    private final Class<?> declaringClass;
    private final Parameter[] parameters;
    private final String methodSignature;
    private final McpResource mcpResourceAnnotation;
    private final McpPrompt mcpPromptAnnotation;
    private final McpTool mcpToolAnnotation;

    public MethodMetadata(Method method) {
        this.method = Immutable.of(method);
        this.methodName = method.getName();
        this.declaringClass = method.getDeclaringClass();
        this.parameters = method.getParameters();
        this.methodSignature = method.toGenericString();
        this.mcpResourceAnnotation = method.getAnnotation(McpResource.class);
        this.mcpPromptAnnotation = method.getAnnotation(McpPrompt.class);
        this.mcpToolAnnotation = method.getAnnotation(McpTool.class);
    }

    public static MethodMetadata of(Method method) {
        return new MethodMetadata(method);
    }

    public Method getMethod() {
        return this.method.get();
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    public Parameter[] getParameters() {
        return (Parameter[])this.parameters.clone();
    }

    public String getMethodSignature() {
        return this.methodSignature;
    }

    public McpResource getMcpResourceAnnotation() {
        return this.mcpResourceAnnotation;
    }

    public McpPrompt getMcpPromptAnnotation() {
        return this.mcpPromptAnnotation;
    }

    public McpTool getMcpToolAnnotation() {
        return this.mcpToolAnnotation;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MethodMetadata that = (MethodMetadata)obj;
        return Objects.equals(this.method, that.method);
    }

    public int hashCode() {
        return Objects.hash(this.method);
    }

    public String toString() {
        return String.format("MethodMetadata{methodSignature=%s}", this.methodSignature);
    }
}

