/*
 * Decompiled with CFR 0.152.
 */
package com.github.codeboyzhou.mcp.declarative.server;

import com.github.codeboyzhou.mcp.declarative.common.NamedThreadFactory;
import jakarta.servlet.Servlet;
import jakarta.servlet.http.HttpServlet;
import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedJettyServer {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedJettyServer.class);
    private static final String DEFAULT_SERVLET_CONTEXT_PATH = "/";
    private static final String DEFAULT_SERVLET_PATH = "/*";
    private final ExecutorService threadPool = Executors.newSingleThreadExecutor(new NamedThreadFactory("mcp-http-server"));
    private HttpServlet servlet;
    private int port;

    public EmbeddedJettyServer use(HttpServlet servlet) {
        this.servlet = servlet;
        return this;
    }

    public EmbeddedJettyServer bind(int port) {
        this.port = port;
        return this;
    }

    public void start() {
        ServletContextHandler handler = new ServletContextHandler(1);
        handler.setContextPath(DEFAULT_SERVLET_CONTEXT_PATH);
        ServletHolder servletHolder = new ServletHolder((Servlet)this.servlet);
        handler.addServlet(servletHolder, DEFAULT_SERVLET_PATH);
        Server httpserver = new Server(this.port);
        httpserver.setHandler((Handler)handler);
        httpserver.setStopAtShutdown(true);
        httpserver.setStopTimeout(Duration.ofSeconds(5L).toMillis());
        try {
            httpserver.start();
            this.addShutdownHook(httpserver);
            log.info("Embedded Jetty server started on http://127.0.0.1:{}", (Object)this.port);
        }
        catch (Exception e) {
            log.error("Error starting embedded Jetty server on http://127.0.0.1:{}", (Object)this.port, (Object)e);
        }
        this.threadPool.submit(() -> this.await(httpserver));
    }

    private void await(Server httpserver) {
        try {
            httpserver.join();
        }
        catch (InterruptedException e) {
            log.error("Error joining embedded Jetty server", (Throwable)e);
        }
    }

    private void addShutdownHook(Server httpserver) {
        Runnable runnable = () -> this.shutdown(httpserver);
        Thread shutdownHookThread = new Thread(runnable);
        Runtime.getRuntime().addShutdownHook(shutdownHookThread);
    }

    private void shutdown(Server httpserver) {
        try {
            log.info("Shutting down embedded Jetty server");
            httpserver.stop();
            this.servlet.destroy();
            this.threadPool.shutdown();
        }
        catch (Exception e) {
            log.error("Error stopping Jetty server", (Throwable)e);
        }
    }
}

