/*
 * Decompiled with CFR 0.152.
 */
package com.github.codeboyzhou.mcp.declarative.server;

import com.github.codeboyzhou.mcp.declarative.server.McpServerInfo;
import io.modelcontextprotocol.common.McpTransportContext;
import io.modelcontextprotocol.server.McpTransportContextExtractor;
import jakarta.servlet.http.HttpServletRequest;
import java.time.Duration;

public class McpStreamableServerInfo
extends McpServerInfo {
    private final int port;
    private final String mcpEndpoint;
    private final boolean disallowDelete;
    private final McpTransportContextExtractor<HttpServletRequest> contextExtractor;
    private final Duration keepAliveInterval;

    private McpStreamableServerInfo(Builder builder) {
        super(builder);
        this.port = builder.port;
        this.mcpEndpoint = builder.mcpEndpoint;
        this.disallowDelete = builder.disallowDelete;
        this.contextExtractor = builder.contextExtractor;
        this.keepAliveInterval = builder.keepAliveInterval;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int port() {
        return this.port;
    }

    public String mcpEndpoint() {
        return this.mcpEndpoint;
    }

    public boolean disallowDelete() {
        return this.disallowDelete;
    }

    public McpTransportContextExtractor<HttpServletRequest> contextExtractor() {
        return this.contextExtractor;
    }

    public Duration keepAliveInterval() {
        return this.keepAliveInterval;
    }

    public static class Builder
    extends McpServerInfo.Builder<Builder> {
        private int port = 8080;
        private String mcpEndpoint = "/mcp";
        private boolean disallowDelete = false;
        private McpTransportContextExtractor<HttpServletRequest> contextExtractor = request -> McpTransportContext.EMPTY;
        private Duration keepAliveInterval;

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public McpStreamableServerInfo build() {
            return new McpStreamableServerInfo(this);
        }

        public Builder port(int port) {
            this.port = port;
            return this.self();
        }

        public Builder mcpEndpoint(String mcpEndpoint) {
            this.mcpEndpoint = mcpEndpoint;
            return this.self();
        }

        public Builder disallowDelete(boolean disallowDelete) {
            this.disallowDelete = disallowDelete;
            return this.self();
        }

        public Builder contextExtractor(McpTransportContextExtractor<HttpServletRequest> contextExtractor) {
            this.contextExtractor = contextExtractor;
            return this.self();
        }

        public Builder keepAliveInterval(Duration keepAliveInterval) {
            this.keepAliveInterval = keepAliveInterval;
            return this.self();
        }
    }
}

