/*
 * Decompiled with CFR 0.152.
 */
package com.github.codeboyzhou.mcp.declarative.server.component;

import com.github.codeboyzhou.mcp.declarative.di.DependencyInjector;
import com.github.codeboyzhou.mcp.declarative.di.DependencyInjectorProvider;
import com.github.codeboyzhou.mcp.declarative.server.component.McpServerComponent;
import com.github.codeboyzhou.mcp.declarative.server.component.McpServerComponentHandler;
import com.github.codeboyzhou.mcp.declarative.util.Strings;
import java.util.Locale;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMcpServerComponent<T, U, R>
implements McpServerComponent<T>,
McpServerComponentHandler<U, R> {
    private static final Logger log = LoggerFactory.getLogger(AbstractMcpServerComponent.class);
    private static final String RESOURCE_BUNDLE_BASE_NAME = "i18n/mcp_server_component_descriptions";
    protected static final String NOT_SPECIFIED = "Not Specified";
    protected final DependencyInjector injector;
    private final ResourceBundle bundle = this.loadResourceBundle();
    private final boolean i18nEnabled;

    protected AbstractMcpServerComponent() {
        this.injector = DependencyInjectorProvider.INSTANCE.getInjector();
        this.i18nEnabled = this.injector.getVariable(Boolean.class, "i18nEnabled");
    }

    protected String resolveComponentAttributeValue(String attributeLiteralValue) {
        if (this.i18nEnabled && this.bundle != null && this.bundle.containsKey(attributeLiteralValue)) {
            return this.bundle.getString(attributeLiteralValue);
        }
        return Strings.defaultIfBlank(attributeLiteralValue, NOT_SPECIFIED);
    }

    private ResourceBundle loadResourceBundle() {
        Locale locale = Locale.getDefault();
        try {
            return ResourceBundle.getBundle(RESOURCE_BUNDLE_BASE_NAME, locale);
        }
        catch (Exception e) {
            log.warn("Can't find resource bundle for base name: {}, locale {}, i18n will be unsupported", (Object)RESOURCE_BUNDLE_BASE_NAME, (Object)locale);
            return null;
        }
    }
}

