/*
 * Decompiled with CFR 0.152.
 */
package com.github.codeboyzhou.mcp.declarative.server.component;

import com.github.codeboyzhou.mcp.declarative.annotation.McpJsonSchemaDefinition;
import com.github.codeboyzhou.mcp.declarative.annotation.McpJsonSchemaDefinitionProperty;
import com.github.codeboyzhou.mcp.declarative.annotation.McpTool;
import com.github.codeboyzhou.mcp.declarative.annotation.McpToolParam;
import com.github.codeboyzhou.mcp.declarative.enums.JsonSchemaDataType;
import com.github.codeboyzhou.mcp.declarative.reflect.MethodMetadata;
import com.github.codeboyzhou.mcp.declarative.reflect.ReflectionCache;
import com.github.codeboyzhou.mcp.declarative.server.component.AbstractMcpServerComponent;
import com.github.codeboyzhou.mcp.declarative.server.converter.McpToolParameterConverter;
import com.github.codeboyzhou.mcp.declarative.util.ObjectMappers;
import com.github.codeboyzhou.mcp.declarative.util.Strings;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.server.McpSyncServerExchange;
import io.modelcontextprotocol.spec.McpSchema;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class McpServerTool
extends AbstractMcpServerComponent<McpServerFeatures.SyncToolSpecification, McpSchema.CallToolRequest, McpSchema.CallToolResult> {
    private static final Logger log = LoggerFactory.getLogger(McpServerTool.class);
    private final McpToolParameterConverter converter;
    private Object instance;

    public McpServerTool() {
        this.converter = this.injector.getInstance(McpToolParameterConverter.class);
    }

    @Override
    public McpServerFeatures.SyncToolSpecification create(Method method) {
        MethodMetadata methodCache = ReflectionCache.INSTANCE.getMethodMetadata(method);
        this.instance = this.injector.getInstance(methodCache.getDeclaringClass());
        McpTool toolMethod = methodCache.getMcpToolAnnotation();
        String name = Strings.defaultIfBlank(toolMethod.name(), methodCache.getMethodName());
        String title = this.resolveComponentAttributeValue(toolMethod.title());
        String description = this.resolveComponentAttributeValue(toolMethod.description());
        McpSchema.JsonSchema paramSchema = this.createJsonSchema(methodCache.getParameters());
        McpSchema.Tool tool = McpSchema.Tool.builder().name(name).title(title).description(description).inputSchema(paramSchema).build();
        log.debug("Registering tool: {} (Cached: {})", (Object)ObjectMappers.toJson(tool), (Object)ReflectionCache.INSTANCE.isCached(method));
        return McpServerFeatures.SyncToolSpecification.builder().tool(tool).callHandler((exchange, request) -> this.invoke(method, description, (McpSyncServerExchange)exchange, (McpSchema.CallToolRequest)request)).build();
    }

    @Override
    public McpSchema.CallToolResult invoke(Method method, String description, McpSyncServerExchange exchange, McpSchema.CallToolRequest request) {
        Object result;
        boolean isError = false;
        MethodMetadata methodCache = ReflectionCache.INSTANCE.getMethodMetadata(method);
        try {
            Map arguments = request.arguments();
            List<Object> convertedParams = this.converter.convertAllParameters(methodCache, arguments);
            result = methodCache.getMethod().invoke(this.instance, convertedParams.toArray());
        }
        catch (Exception e) {
            log.error("Error invoking tool method: {}", (Object)methodCache.getMethodSignature(), (Object)e);
            result = String.valueOf(e) + ": " + e.getMessage();
            isError = true;
        }
        String text = result == null ? "This tool returned nullable or void" : result.toString();
        McpSchema.TextContent content = new McpSchema.TextContent(text);
        return new McpSchema.CallToolResult(List.of(content), Boolean.valueOf(isError));
    }

    private McpSchema.JsonSchema createJsonSchema(Parameter[] methodParams) {
        LinkedHashMap properties = new LinkedHashMap();
        LinkedHashMap<String, Map<String, Object>> definitions = new LinkedHashMap<String, Map<String, Object>>();
        ArrayList<String> required = new ArrayList<String>();
        for (Parameter param : methodParams) {
            if (!param.isAnnotationPresent(McpToolParam.class)) continue;
            McpToolParam toolParam = param.getAnnotation(McpToolParam.class);
            String parameterName = toolParam.name();
            Class<?> definitionClass = param.getType();
            HashMap<String, Object> property = new HashMap<String, Object>();
            if (definitionClass.isAnnotationPresent(McpJsonSchemaDefinition.class)) {
                String definitionClassName = definitionClass.getSimpleName();
                property.put("$ref", "#/definitions/" + definitionClassName);
                Map<String, Object> definition = this.createJsonSchemaDefinition(definitionClass);
                definitions.put(definitionClassName, definition);
            } else {
                property.put("type", definitionClass.getSimpleName().toLowerCase());
                property.put("description", this.resolveComponentAttributeValue(toolParam.description()));
            }
            properties.put(parameterName, property);
            if (!toolParam.required()) continue;
            required.add(parameterName);
        }
        boolean hasAdditionalProperties = false;
        return new McpSchema.JsonSchema(JsonSchemaDataType.OBJECT.getType(), properties, required, Boolean.valueOf(false), definitions, definitions);
    }

    private Map<String, Object> createJsonSchemaDefinition(Class<?> definitionClass) {
        HashMap<String, Object> definitionJsonSchema = new HashMap<String, Object>();
        definitionJsonSchema.put("type", JsonSchemaDataType.OBJECT.getType());
        LinkedHashMap properties = new LinkedHashMap();
        ArrayList<String> required = new ArrayList<String>();
        Reflections reflections = this.injector.getInstance(Reflections.class);
        Set definitionFields = reflections.getFieldsAnnotatedWith(McpJsonSchemaDefinitionProperty.class);
        List<Field> fields = definitionFields.stream().filter(f -> f.getDeclaringClass() == definitionClass).toList();
        for (Field field : fields) {
            McpJsonSchemaDefinitionProperty property = field.getAnnotation(McpJsonSchemaDefinitionProperty.class);
            if (property == null) continue;
            HashMap<String, String> fieldProperties = new HashMap<String, String>();
            fieldProperties.put("type", JsonSchemaDataType.fromJavaType(field.getType()).getType());
            fieldProperties.put("description", this.resolveComponentAttributeValue(property.description()));
            String fieldName = Strings.defaultIfBlank(property.name(), field.getName());
            properties.put(fieldName, fieldProperties);
            if (!property.required()) continue;
            required.add(fieldName);
        }
        definitionJsonSchema.put("properties", properties);
        definitionJsonSchema.put("required", required);
        return definitionJsonSchema;
    }
}

