/*
 * Decompiled with CFR 0.152.
 */
package com.github.codeboyzhou.mcp.declarative.server.configurable;

import com.github.codeboyzhou.mcp.declarative.configuration.McpServerConfiguration;
import com.github.codeboyzhou.mcp.declarative.configuration.McpServerSSE;
import com.github.codeboyzhou.mcp.declarative.server.EmbeddedJettyServer;
import com.github.codeboyzhou.mcp.declarative.server.configurable.AbstractConfigurableMcpServer;
import io.modelcontextprotocol.server.McpServer;
import io.modelcontextprotocol.server.transport.HttpServletSseServerTransportProvider;
import io.modelcontextprotocol.spec.McpServerTransportProvider;
import jakarta.servlet.http.HttpServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurableMcpSseServer
extends AbstractConfigurableMcpServer {
    private static final Logger log = LoggerFactory.getLogger(ConfigurableMcpSseServer.class);

    public ConfigurableMcpSseServer(McpServerConfiguration configuration) {
        super(configuration);
    }

    @Override
    public McpServer.SyncSpecification<?> sync() {
        log.warn("HTTP SSE mode has been deprecated, recommend to use Stream HTTP server instead.");
        McpServerSSE sse = this.configuration.sse();
        HttpServletSseServerTransportProvider transportProvider = HttpServletSseServerTransportProvider.builder().baseUrl(sse.baseUrl()).sseEndpoint(sse.endpoint()).messageEndpoint(sse.messageEndpoint()).build();
        EmbeddedJettyServer httpserver = new EmbeddedJettyServer();
        httpserver.use((HttpServlet)transportProvider).bind(sse.port()).start();
        return McpServer.sync((McpServerTransportProvider)transportProvider);
    }
}

