/*
 * Decompiled with CFR 0.152.
 */
package com.github.codeboyzhou.mcp.declarative.util;

import com.github.codeboyzhou.mcp.declarative.enums.JsonSchemaDataType;
import org.jetbrains.annotations.VisibleForTesting;

public final class Types {
    @VisibleForTesting
    Types() {
        throw new UnsupportedOperationException("Utility class should not be instantiated");
    }

    public static Object convert(Object value, Class<?> targetType) {
        if (value == null) {
            return Types.getDefaultValue(targetType);
        }
        String valueAsString = value.toString();
        if (targetType == String.class) {
            return valueAsString;
        }
        if (targetType == Integer.TYPE || targetType == Integer.class) {
            return Integer.parseInt(valueAsString);
        }
        if (targetType == Long.TYPE || targetType == Long.class) {
            return Long.parseLong(valueAsString);
        }
        if (targetType == Float.TYPE || targetType == Float.class) {
            return Float.valueOf(Float.parseFloat(valueAsString));
        }
        if (targetType == Double.TYPE || targetType == Double.class) {
            return Double.parseDouble(valueAsString);
        }
        if (targetType == Boolean.TYPE || targetType == Boolean.class) {
            return Boolean.parseBoolean(valueAsString);
        }
        return valueAsString;
    }

    public static Object convert(Object value, String jsonSchemaType) {
        if (value == null) {
            return Types.getDefaultValue(jsonSchemaType);
        }
        String valueAsString = value.toString();
        if (JsonSchemaDataType.STRING.getType().equals(jsonSchemaType)) {
            return valueAsString;
        }
        if (JsonSchemaDataType.INTEGER.getType().equals(jsonSchemaType)) {
            return Integer.parseInt(valueAsString);
        }
        if (JsonSchemaDataType.NUMBER.getType().equals(jsonSchemaType)) {
            return Double.parseDouble(valueAsString);
        }
        if (JsonSchemaDataType.BOOLEAN.getType().equals(jsonSchemaType)) {
            return Boolean.parseBoolean(valueAsString);
        }
        return valueAsString;
    }

    private static Object getDefaultValue(Class<?> type) {
        if (type == String.class) {
            return "";
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return 0;
        }
        if (type == Long.TYPE || type == Long.class) {
            return 0L;
        }
        if (type == Float.TYPE || type == Float.class) {
            return Float.valueOf(0.0f);
        }
        if (type == Double.TYPE || type == Double.class) {
            return 0.0;
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return false;
        }
        return null;
    }

    private static Object getDefaultValue(String jsonSchemaType) {
        if (JsonSchemaDataType.STRING.getType().equalsIgnoreCase(jsonSchemaType)) {
            return "";
        }
        if (JsonSchemaDataType.INTEGER.getType().equalsIgnoreCase(jsonSchemaType)) {
            return 0;
        }
        if (JsonSchemaDataType.NUMBER.getType().equalsIgnoreCase(jsonSchemaType)) {
            return 0.0;
        }
        if (JsonSchemaDataType.BOOLEAN.getType().equalsIgnoreCase(jsonSchemaType)) {
            return false;
        }
        return null;
    }
}

