package com.ctyun.utils;

import com.ctyun.constants.AIConstant;

import java.io.*;
import java.net.URL;
import java.net.URLConnection;
import java.util.Base64;
import java.util.Base64.*;

public class Base64Utils {

    private static Encoder encoder;
    private static Encoder urlEncoder;
    private static Decoder decoder;
    private static Decoder urlDecoder;

    static {
        encoder = Base64.getEncoder();
        urlEncoder = Base64.getUrlEncoder();
        decoder = Base64.getDecoder();
        urlDecoder = Base64.getUrlDecoder();
    }

//    public static String getBase64FromImgURL(String src) {
//        URL url;
//        try {
//            url = new URL(src);
//        } catch (MalformedURLException e) {
//            throw new RuntimeException(e);
//        }
//        InputStream in;
//        byte[] data = null;
//        try {
//            in = url.openStream();
//            data = new byte[in.available()];
//            in.read(data);
//            in.close();
//        } catch (IOException e) {
//            e.printStackTrace();
//        }
//        return encoder.encodeToString(data);
//    }

    public static String getBase64FromImgURL(String url) {
        InputStream in;
        byte[] data = null;
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try {
            URLConnection connection = new URL(url).openConnection();
            in = connection.getInputStream();
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = in.read(buffer)) != -1) {
                outStream.write(buffer, 0, len);
            }
            data = outStream.toByteArray();
            in.close();
            outStream.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return encoder.encodeToString(data);
    }

    public static String getBase64FromImgFile(String imgPath) {
        byte[] data = null;
        FileInputStream in = null;
        try {
            in = new FileInputStream(imgPath);
            data = new byte[in.available()];
            in.read(data);
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                in.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return encoder.encodeToString(data);
    }

    public static byte[] base64ToByteArr(String base64str, String fileType) {
        byte[] imageData = null;
        switch (fileType) {
            case AIConstant.IMAGE:
                imageData = decoder.decode(base64str);
                break;
            case AIConstant.FACE_MAKEUP_IMAGE:
                imageData = urlDecoder.decode(base64str);
                break;
            case AIConstant.AUDIO:
                imageData = urlDecoder.decode(base64str);
                break;
            default:
                break;
        }
        return imageData;

    }
}
