/*
 * Decompiled with CFR 0.152.
 */
package com.ctyun;

import com.ctyun.EbpContext;
import com.ctyun.Header;
import com.ctyun.HttpRequest;
import com.ctyun.security.MD5;
import java.util.UUID;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;

public class CtYunSDK {
    public static final String METHOD_GET = "get";
    public static final String METHOD_POST = "post";
    private String method = "get";
    private EbpContext context = new EbpContext();
    private String appKey;
    private String appId;
    private String requestId = UUID.randomUUID().toString();
    private boolean isMd5Sign = false;
    private String connection = "close";

    public CtYunSDK(String appId, String appKey, EbpContext body) {
        this.appId = appId;
        this.appKey = appKey;
        this.context = body;
    }

    public CtYunSDK(String appId, String appKey, ServletRequest request) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        this.appId = httpServletRequest.getHeader("X-APP-ID");
        this.appKey = httpServletRequest.getHeader("X-APP-KEY");
        this.requestId = httpServletRequest.getHeader("X-Transaction-ID");
        this.context.setClientIp(httpServletRequest.getHeader("ORIG_CLIENT_IP"));
    }

    public String call() {
        StringBuilder sb;
        block10: {
            if (StringUtils.isBlank((String)this.appKey)) {
                throw new RuntimeException("appKey\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isBlank((String)this.appId)) {
                throw new RuntimeException("appId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            String wsUrl = this.context.getRequestUrl();
            this.context.getHeaders().add(new Header("X-APP-ID", this.appId));
            this.context.getHeaders().add(new Header("X-APP-KEY", this.appKey));
            this.context.getHeaders().add(new Header("ORIG_CLIENT_IP", this.context.getClientIp()));
            this.context.getHeaders().add(new Header("X-CTG-Request-ID", this.requestId));
            this.context.getHeaders().add(new Header("Connection", this.connection));
            if (this.isMd5Sign) {
                this.context.getHeaders().add(new Header("md5Sign", MD5.getInstance().getMD532(this.context.getParams())));
            }
            String result = this.method.equals(METHOD_POST) ? HttpRequest.sendPost(wsUrl, this.context.getParams(), this.context.getHeaders()) : HttpRequest.sendGet(wsUrl, this.context.getParams(), this.context.getHeaders());
            result = result.replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&quot;", "\"");
            sb = new StringBuilder();
            if (result.contains("<?xml")) {
                sb.append(result.substring(0, result.indexOf("<?xml")));
                sb.append("<![cdata[");
                sb.append(result.substring(result.indexOf("<?xml"), result.indexOf("</xml>") + 6));
                sb.append("]]>");
                sb.append(result.substring(result.indexOf("</xml>") + 6));
            } else {
                JSONObject ro = new JSONObject();
                ro.put((Object)"code", (Object)200);
                try {
                    JSONArray array = JSONArray.fromObject((Object)result);
                    ro.put((Object)"data", (Object)array.toString());
                    sb.append(ro.toString());
                }
                catch (Exception a) {
                    try {
                        JSONObject data = JSONObject.fromObject((Object)result);
                        ro.put((Object)"data", (Object)data.toString());
                        sb.append(ro.toString());
                    }
                    catch (Exception e) {
                        if (result.contains("timed out")) {
                            ro.put((Object)"code", (Object)408);
                            ro.put((Object)"message", (Object)"\u8bf7\u6c42\u8d85\u65f6");
                            sb.append(ro.toString());
                            break block10;
                        }
                        ro.put((Object)"code", (Object)500);
                        ro.put((Object)"message", (Object)result);
                        sb.append(ro.toString());
                    }
                }
            }
        }
        return sb.toString();
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setMd5Sign(boolean md5Sign) {
        this.isMd5Sign = md5Sign;
    }
}

