package com.ctyun.utils;

import com.ctyun.utils.responsebody.FaceAugmentingResponseBody;
import com.ctyun.utils.responsebody.FaceProcessingResponseBody;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ctyun.common.Response;
import com.ctyun.utils.responsebody.SuperResResponseBody;
import com.ctyun.utils.responsebody.TTSResponseBody;

import java.io.FileOutputStream;
import java.io.IOException;

public class ResponseUtils {

    public static ObjectMapper objectMapper = new ObjectMapper();

    public static byte[] getByteArrFromResponseBodyForSuperRes(Response response, String type) {
        SuperResResponseBody body;
        try {
            body = objectMapper.readValue(response.getBody(), SuperResResponseBody.class);
        } catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        String imgData = body.getResult().getData();
        return Base64Utils.base64ToByteArr(imgData, type);
    }
    public static byte[] getByteArrFromResponseBodyForFaceAugmenting(Response response, String type) {
        FaceAugmentingResponseBody body;
        try {
            body = objectMapper.readValue(response.getBody(), FaceAugmentingResponseBody.class);
        } catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        String imgData = body.getResult();
        return Base64Utils.base64ToByteArr(imgData, type);
    }

    public static byte[] getByteArrFromResponseBodyForFaceProcessing(Response response, String type) {
        FaceProcessingResponseBody body;
        try {
            body = objectMapper.readValue(response.getBody(), FaceProcessingResponseBody.class);
        } catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        String imgData = body.getResult().getImage();
        return Base64Utils.base64ToByteArr(imgData, type);
    }
    public static byte[] getByteArrFromResponseBodyForAudio(Response response, String type) {
        TTSResponseBody body;
        try {
            body = objectMapper.readValue(response.getBody(), TTSResponseBody.class);
        } catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        String wavData = body.getResult().getAudio();
        return Base64Utils.base64ToByteArr(wavData, type);
    }

    public static void byteArrToFile(byte[] byteArr, String filePath) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(filePath);
            out.write(byteArr);
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                out.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

