/*
 * Decompiled with CFR 0.152.
 */
package io.github.danielnaczo.python3parser.model.stmts.compoundStmts.withStmts;

import io.github.danielnaczo.python3parser.model.stmts.Body;
import io.github.danielnaczo.python3parser.model.stmts.Statement;
import io.github.danielnaczo.python3parser.model.stmts.compoundStmts.withStmts.WithItem;
import io.github.danielnaczo.python3parser.visitors.basic.Python3ASTVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class With
extends Statement {
    List<WithItem> items;
    Statement body;

    public With() {
        this(null, null);
    }

    public With(List<WithItem> items) {
        this(items, null);
    }

    public With(List<WithItem> items, Statement body) {
        this.items = items != null ? items : new ArrayList();
        this.body = body;
        this.setParentToBody();
    }

    public List<WithItem> getItems() {
        return this.items;
    }

    public Statement getBody() {
        return this.body;
    }

    public void setItems(List<WithItem> items) {
        this.items = items;
    }

    public void setBody(Statement body) {
        this.body = body;
        this.setParentToBody();
    }

    public Statement addStatement(Statement statement) {
        if (this.body == null) {
            this.body = statement;
            return statement;
        }
        this.body = this.transformStmtToBody();
        Body body = (Body)this.body;
        body.addStatement(statement);
        return statement;
    }

    public WithItem addWithItem(WithItem item) {
        this.items.add(item);
        return item;
    }

    private void setParentToBody() {
        if (this.body instanceof Body) {
            ((Body)this.body).setParentStmt(this);
        }
    }

    private Body transformStmtToBody() {
        if (this.body instanceof Body) {
            return (Body)this.body;
        }
        Statement statement = this.body;
        ArrayList<Statement> statements = new ArrayList<Statement>();
        statements.add(statement);
        Body body = new Body(statements);
        body.setParentStmt(this);
        return body;
    }

    @Override
    public <R, P> R accept(Python3ASTVisitor<R, P> visitor, P param) {
        return visitor.visitWith(this, param);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        With with = (With)o;
        return Objects.equals(this.items, with.items) && Objects.equals(this.body, with.body);
    }

    public int hashCode() {
        return Objects.hash(this.items, this.body);
    }

    public String toString() {
        return "With";
    }
}

