/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.datafusion;

import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.apache.arrow.datafusion.AbstractProxy;
import org.apache.arrow.datafusion.DataFrame;
import org.apache.arrow.datafusion.DefaultDataFrame;
import org.apache.arrow.datafusion.ExecutionContext;
import org.apache.arrow.datafusion.ExecutionContexts;
import org.apache.arrow.datafusion.ObjectResultCallback;
import org.apache.arrow.datafusion.Runtime;
import org.apache.arrow.datafusion.TokioRuntime;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class DefaultExecutionContext
extends AbstractProxy
implements ExecutionContext {
    private static final Logger logger = LogManager.getLogger(DefaultExecutionContext.class);
    private final TokioRuntime runtime = TokioRuntime.create();

    static native void querySql(long var0, long var2, String var4, ObjectResultCallback var5);

    static native void registerCsv(long var0, long var2, String var4, String var5, Consumer<String> var6);

    static native void registerParquet(long var0, long var2, String var4, String var5, Consumer<String> var6);

    @Override
    public CompletableFuture<DataFrame> sql(String sql) {
        long runtime = this.getRuntime().getPointer();
        CompletableFuture<DataFrame> future = new CompletableFuture<DataFrame>();
        DefaultExecutionContext.querySql(runtime, this.getPointer(), sql, (errMessage, dataframeId) -> {
            if (null != errMessage && !errMessage.equals("")) {
                future.completeExceptionally(new RuntimeException(errMessage));
            } else {
                DefaultDataFrame frame = new DefaultDataFrame(this, dataframeId);
                future.complete(frame);
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> registerCsv(String name, Path path) {
        long runtime = this.getRuntime().getPointer();
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        DefaultExecutionContext.registerCsv(runtime, this.getPointer(), name, path.toAbsolutePath().toString(), errMessage -> this.voidCallback(future, (String)errMessage));
        return future;
    }

    @Override
    public CompletableFuture<Void> registerParquet(String name, Path path) {
        long runtime = this.getRuntime().getPointer();
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        DefaultExecutionContext.registerParquet(runtime, this.getPointer(), name, path.toAbsolutePath().toString(), errMessage -> this.voidCallback(future, (String)errMessage));
        return future;
    }

    private void voidCallback(CompletableFuture<Void> future, String errMessage) {
        if (null != errMessage && !errMessage.equals("")) {
            future.completeExceptionally(new RuntimeException(errMessage));
        } else {
            future.complete(null);
        }
    }

    @Override
    public Runtime getRuntime() {
        return this.runtime;
    }

    DefaultExecutionContext(long pointer) {
        super(pointer);
        this.registerChild(this.runtime);
    }

    @Override
    void doClose(long pointer) throws Exception {
        ExecutionContexts.destroyExecutionContext(pointer);
    }
}

