/*
 * Decompiled with CFR 0.152.
 */
package com.devintest.api.resources.imdb;

import com.devintest.api.core.ClientOptions;
import com.devintest.api.core.RequestOptions;
import com.devintest.api.resources.imdb.AsyncRawImdbClient;
import com.devintest.api.resources.imdb.types.CreateMovieRequest;
import com.devintest.api.resources.imdb.types.Movie;
import java.util.concurrent.CompletableFuture;

public class AsyncImdbClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawImdbClient rawClient;

    public AsyncImdbClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawImdbClient(clientOptions);
    }

    public AsyncRawImdbClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<String> createMovie(CreateMovieRequest request) {
        return this.rawClient.createMovie(request).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<String> createMovie(CreateMovieRequest request, RequestOptions requestOptions) {
        return this.rawClient.createMovie(request, requestOptions).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<Movie> getMovie(String id) {
        return this.rawClient.getMovie(id).thenApply(response -> (Movie)response.body());
    }

    public CompletableFuture<Movie> getMovie(String id, RequestOptions requestOptions) {
        return this.rawClient.getMovie(id, requestOptions).thenApply(response -> (Movie)response.body());
    }
}

