/*
 * Decompiled with CFR 0.152.
 */
package com.devintest.api.resources.imdb.types;

import com.devintest.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Movie {
    private final String id;
    private final String title;
    private final double rating;
    private final Map<String, Object> additionalProperties;

    private Movie(String id, String title, double rating, Map<String, Object> additionalProperties) {
        this.id = id;
        this.title = title;
        this.rating = rating;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="rating")
    public double getRating() {
        return this.rating;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Movie && this.equalTo((Movie)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Movie other) {
        return this.id.equals(other.id) && this.title.equals(other.title) && this.rating == other.rating;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.title, this.rating);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    TitleStage,
    RatingStage,
    _FinalStage {
        private String id;
        private String title;
        private double rating;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Movie other) {
            this.id(other.getId());
            this.title(other.getTitle());
            this.rating(other.getRating());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public TitleStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="title")
        public RatingStage title(@NotNull String title) {
            this.title = Objects.requireNonNull(title, "title must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="rating")
        public _FinalStage rating(double rating) {
            this.rating = rating;
            return this;
        }

        @Override
        public Movie build() {
            return new Movie(this.id, this.title, this.rating, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Movie build();
    }

    public static interface RatingStage {
        public _FinalStage rating(double var1);
    }

    public static interface TitleStage {
        public RatingStage title(@NotNull String var1);
    }

    public static interface IdStage {
        public TitleStage id(@NotNull String var1);

        public Builder from(Movie var1);
    }
}

