/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.easy.http.helper;

import io.gitbub.devlibx.easy.helper.Safe;
import io.github.devlibx.easy.http.config.Api;
import io.github.devlibx.easy.http.config.Server;
import io.github.devlibx.easy.http.helper.IClientBuilder;
import io.opentracing.contrib.apache.http.client.TracingHttpClientBuilder;
import io.opentracing.util.GlobalTracer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientBuilder
implements IClientBuilder {
    private static final Logger log = LoggerFactory.getLogger(HttpClientBuilder.class);
    private final ScheduledExecutorService executorService;
    private final Map<String, CloseableHttpClient> httpClientMap = new ConcurrentHashMap<String, CloseableHttpClient>();

    public HttpClientBuilder() {
        this.executorService = Executors.newScheduledThreadPool(2);
    }

    @Override
    public boolean accept(Server server, Api api) {
        if (api.isAsync()) {
            return false;
        }
        return "HTTP".equals(api.getType()) || "HTTPS".equals(api.getType());
    }

    @Override
    public <T> T buildClient(Server server, Api api, Class<T> cls) {
        if (!cls.isAssignableFrom(CloseableHttpClient.class)) {
            throw new RuntimeException("cls type must be CloseableHttpClient");
        }
        if (!this.httpClientMap.containsKey(server.getName() + "-" + api.getName())) {
            CloseableHttpClient client = this.buildHttpClient(server, api);
            this.httpClientMap.put(server.getName() + "-" + api.getName(), client);
        }
        return (T)this.httpClientMap.get(server.getName() + "-" + api.getName());
    }

    @Override
    public void shutdown() {
        Safe.safe(this.executorService::shutdown);
        Safe.safe(() -> this.httpClientMap.forEach((key, closeableHttpClient) -> {
            log.info("Closing connections: key={}", key);
            Safe.safe(() -> {
                try {
                    closeableHttpClient.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }));
    }

    public CloseableHttpClient buildHttpClient(Server server, Api api) {
        PoolingHttpClientConnectionManager connectionManager = server.getPollingConnectionTtlInMs() > 0 ? new PoolingHttpClientConnectionManager((long)server.getPollingConnectionTtlInMs(), TimeUnit.MILLISECONDS) : new PoolingHttpClientConnectionManager();
        connectionManager.setMaxTotal(api.getConcurrency());
        connectionManager.setDefaultMaxPerRoute(api.getConcurrency());
        this.executorService.scheduleWithFixedDelay(() -> {
            connectionManager.closeExpiredConnections();
            connectionManager.closeIdleConnections((long)server.getIdleConnectionTimeoutInSec(), TimeUnit.SECONDS);
        }, 10L, 30L, TimeUnit.SECONDS);
        TracingHttpClientBuilder builder = new TracingHttpClientBuilder().withTracer(GlobalTracer.get());
        builder.setDefaultRequestConfig(RequestConfig.custom().setRedirectsEnabled(true).build());
        builder.setConnectionManager((HttpClientConnectionManager)connectionManager);
        return builder.build();
    }
}

