package io.github.devsecops.engine.core;

import io.github.devsecops.engine.core.contract.Factory;
import io.github.devsecops.engine.core.contract.Invoker;
import io.github.devsecops.engine.core.model.BuildParam;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractSpringMojo extends AbstractMojo {

    @Parameter(property = "env", defaultValue = "local")
    private String env;

    @Parameter(property = "increaseVersion", defaultValue = "false")
    private String increaseVersion;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            AnnotationConfigApplicationContext ctx = new AnnotationConfigApplicationContext();
            ctx.scan("io.github.devsecops.engine");
            ctx.refresh();
            Factory<Invoker> factory = (Factory<Invoker>) ctx.getBean(Class.forName(getInvokerClass()));

            getLog().info("Generating config files for env");
            Invoker invoker = factory.build(getBuildParameters());
            invoker.execute();
            ctx.close();
        } catch (Exception e) {
            getLog().error(e);
        }
    }

    public abstract String getInvokerClass();

    private Map<String, String> getBuildParameters() {
        return Stream.of( new String[][] {
                {BuildParam.ENV.name(), env},
                {BuildParam.INCREASE_VERSION.name(), increaseVersion}
                }
        ).collect(Collectors.toMap(data -> data[0], data -> data[1]));
    }

}
