package io.github.devsecops.engine.core;

import io.github.devsecops.engine.core.contract.Executor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.util.Map;
import java.util.stream.Stream;

@Component
public class BashShellExecutor extends Executor {

    @Autowired
    private Log log;
    private File logFile = new File("engine-plugin.log");

    @Override
    public String execute(String cmd, Map<String, String> params) throws IOException, InterruptedException {
        //Files.deleteIfExists(logFile.toPath());
        log.info(String.format("Executing command : %s", cmd));
        ProcessBuilder processBuilder = new ProcessBuilder("bash", "-c", cmd).redirectOutput(logFile).redirectErrorStream(true);

        if (!CollectionUtils.isEmpty(params)) {
            processBuilder.environment().putAll(params);
//            params.forEach((k, v) -> processBuilder.environment().put(k, v));
        }
        Process process = processBuilder.start();
        int status = process.waitFor();
        if (status != 0) {
            logError(cmd, status);
            throw new InterruptedException();
        } else {
            log.info(String.format("Command: %s >>>> OK", cmd));
            return getLogsMessages(cmd);
        }
    }

    private String getLogsMessages(String cmd) throws IOException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter, true);
        Stream<String> lines = Files.readAllLines(logFile.toPath()).stream().map(String::toString);
        lines.forEach(s -> printWriter.println(s));
        return stringWriter.toString();


    }

    private void logError(String cmd, int status) throws IOException {
        log.error(String.format("Command: %s ended with status: %s", cmd, status));
        log.error(getLogsMessages(cmd));
    }
}

