package io.github.devsecops.engine.core.model;

import lombok.Getter;
import org.apache.maven.model.Model;

import java.util.Optional;

@Getter
public class Pom {

    private static Pom INSTANCE;

    public static Pom getINSTANCE() {
        if (INSTANCE == null) {
            INSTANCE = new Pom();
        }
        return INSTANCE;
    }
    private final String groupId;
    private final String artifactId;
    private String version;

    private Pom() {
        final Model model = PomModelUtils.read();
        this.groupId = model.getGroupId();
        this.artifactId = model.getArtifactId();
        this.version = model.getVersion();
    }

    public void removeQualifierFromVersion() {
        updateVersion(version.replace("-SNAPSHOT", ""));
    }

    public String getJarNam() {
        return String.format("%s-%s.jar", artifactId, version);
    }
    public Optional<SemanticVersion> getSemanticVersion() {
        return version == null? Optional.empty() : SemanticVersionMapper.toSemanticVersion(version);

    }

    public void updateVersion(String version) {
        this.version = version;
        final Model model = PomModelUtils.read();
        model.setVersion(version);
        PomModelUtils.update(model);

    }
}
