package io.github.devsecops.engine.core.model;

import lombok.experimental.UtilityClass;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

@UtilityClass
public class PomModelUtils {

    public static Model read() {
        try {
            FileReader fileReader = new FileReader("pom.xml");
            MavenXpp3Reader reader = new MavenXpp3Reader();
            Model model = reader.read(fileReader);
            return model;
        } catch (Exception e) {
            throw new RuntimeException("Pom model issue");
        }
    }

    public static void update(Model model) {
        MavenXpp3Writer writer = new MavenXpp3Writer();
        try {
            FileWriter fileWriter = new FileWriter("pom.xml");
            writer.write(fileWriter, model);
        } catch (IOException e) {
            throw new RuntimeException("Couldn't update pom file to update version");
        }
    }
}
