package io.github.devsecops.engine.core.model;

import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public class SemanticVersion {

    private int major;
    private int minor;
    private int patch;
    private String qualifier;

    public SemanticVersion incrementPatch() {
        this.patch++;
        return this;
    }
    public String toString() {
        return String.format("%s.%s.%s-%s", major, minor, patch, qualifier);
    }

    public boolean isSnapshot() {
        return "SNAPSHOT".equals(qualifier);
    }
}
