package io.github.devsecops.engine.core.model;

import lombok.experimental.UtilityClass;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@UtilityClass
public class SemanticVersionMapper {

    private static final String WITH_QUALIFIER_REGEX = "([1-9]\\d*)\\.(\\d+)\\.(\\d+)(?:-([a-zA-z0-9]+))?";
    private static final String WITHOUT_QUALIFIER_REGEX = "([1-9]\\d*)\\.(\\d+)\\.(\\d+)?";
    private static final String DEFAULT_QUALIFIER = "SNAPSHOT";

    public static Optional<SemanticVersion> toSemanticVersion(String version) {
        final String regex = version.contains("-") ? WITH_QUALIFIER_REGEX : WITHOUT_QUALIFIER_REGEX;
        final Pattern pattern = Pattern.compile(regex);
        final Matcher matcher = pattern.matcher(version);
        if (!matcher.matches()) {
            return Optional.empty();
        }
        int major = Integer.parseInt(matcher.group(1));
        int minor = Integer.parseInt(matcher.group(2));
        int patch = Integer.parseInt(matcher.group(3));
        String qualifier;
        try {
            qualifier = matcher.group(4);
        } catch (Exception e) {
            qualifier = DEFAULT_QUALIFIER;
        }
        return Optional.of(new SemanticVersion(major, minor, patch, qualifier));

    }
}
