package io.github.devsecops.engine.core.resolver;


import io.github.devsecops.engine.core.model.PathCompose;
import io.github.devsecops.engine.core.model.PathList;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Stream;

import static io.github.devsecops.engine.core.model.Environment.*;
import static java.util.stream.Collectors.toMap;

@Configuration
public class PathListConfig {
    @Qualifier("PathList")
    @Bean
    public Map<String, PathList> getMap() {
        return Stream.of(
                new AbstractMap.SimpleEntry<>(LOCAL.name(), getFromVar("local")),
                new AbstractMap.SimpleEntry<>(DEV.name(), getFromVar("dev")),
                new AbstractMap.SimpleEntry<>(UAT.name(), getFromVar("uat"))
        ).collect(toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private PathList getDefault() {
        final PathList pathList = new PathList(Arrays.asList(
                PathCompose.builder().path("/vars/infra.properties").resource(true).build(),
                PathCompose.builder().path("ci/vars/default.properties").build()
        ));
        return pathList;
    }

    private PathList getFromVar(String var) {
        final PathList pathList = new PathList(Arrays.asList(
                getDefault().getPaths().get(0),
                getDefault().getPaths().get(1),
                PathCompose.builder().path("ci/vars/" + var + ".properties").build()
        ));
        return pathList;
    }
}
