package io.github.devsecops.engine.core.resolver;

import io.github.devsecops.engine.core.Log;
import io.github.devsecops.engine.core.contract.Factory;
import io.github.devsecops.engine.core.model.BuildParam;
import io.github.devsecops.engine.core.model.PathList;
import io.github.devsecops.engine.core.resolver.strategy.EnvironmentResolverStrategy;
import io.github.devsecops.engine.core.resolver.strategy.PropertyFileResolverStrategy;
import io.github.devsecops.engine.core.resolver.strategy.Resolver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.Map;

@Service
public class PathResolverBuilder implements Factory<Resolver> {

    @Autowired
    private Log logger;

    @Autowired
    @Qualifier("PathList")
    private Map<String, PathList> pathListMap;

    private PathList getPathList(Map<String, String> parameters) throws Exception {
        return pathListMap.get(parameters.get(BuildParam.ENV.name()).toUpperCase());
    }

    @Override
    public Resolver build(Map<String, String> parameters) throws Exception {
        PathList pathList = this.getPathList(parameters);
//        TODO VAULT
        return new Resolver(new PropertyFileResolverStrategy(pathList), new EnvironmentResolverStrategy(), logger);
    }
}
