package io.github.devsecops.engine.core.resolver;

import io.github.devsecops.engine.core.resolver.strategy.Resolver;
import org.springframework.stereotype.Service;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Service
public class TokenReplacement {
    private static final String KEY = "propertyName";
    private static final String SUB_PATTERN = "\\$\\{(?<" + KEY + ">[A-Za-z_\\.]+)}";
    private final Pattern pattern = Pattern.compile(SUB_PATTERN);
    private Resolver resolver;

    public void setResolver(Resolver resolver) {
        this.resolver = resolver;
    }

    public String replace(String line) {
        Matcher matcher = pattern.matcher(line);
        while(matcher.find()) {
            final String propertyName = matcher.group(KEY);
            line = matcher.replaceFirst(Matcher.quoteReplacement(resolver.resolve(propertyName)));
            matcher = pattern.matcher(line);
        }
        return line;
    }
}
